/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.util.net.*;
import talon.references.*;


/**
 * Test out Component.getInterfaces()
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test9.java,v 1.6 2001/04/14 18:03:50 burton Exp $
 */
public class Test9 extends AbstractTestlet implements Serializable {

    public void initialize( TestletContext context ) throws Exception {

        Component test = getTestComponent();
        
        Class[] classes = ReferenceFactory.getInterfaces( test.getClass() );

        System.out.println( "dumping interfaces...." );

        for ( int i = 0; i < classes.length; ++i ) {

            System.out.println( "Found interface: " + classes[i].getName() );
            
        } 

        System.out.println( "TypeReference: " + test.getTypeReference() );
        
    }
    
    public Component getTestComponent() throws Exception {

//          PropertyManagerPayload test = (PropertyManagerPayload)ComponentFactory
//              .getInstance( PropertyManagerPayload.class.getName() );

//          return test;


        ComponentHandle handle = new ComponentHandle()
            .setImplementation( SimpleLogger.class.getName() );

        Component test = ComponentFactory.getInstance( handle );

        return test;
        
    }
}
