/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.util.net.*;


/**
 * Get a handle onto a component but have it require properties that only exist
 * within the property file.  This tests out the Intializer so that we can
 * verify that it correctly merges properties.  
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test6.java,v 1.3 2001/04/14 18:03:50 burton Exp $
 */
public class Test6 extends AbstractTestlet {


    public void initialize( TestletContext context ) throws Exception {

        ComponentHandle handle = HandleManager.byName( "default_property_manager" );

        handle.getInitProperties().dump();
        
        if ( handle.getInitProperties().getString( "project" )  == null ) {
            throw new Exception( "'project' property not found." );
        } 
        
        
    }

}

