/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.arrowhead.testlet.*;

import talon.*;
import talon.components.*;

/**
 * Testing properties for a specific component.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test4.java,v 1.6 2001/04/14 18:03:50 burton Exp $
 */
public class Test4 extends AbstractTestlet {


    /**
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Test4.java,v 1.6 2001/04/14 18:03:50 burton Exp $
     */
    public void initialize( TestletContext context ) throws Exception {

        //get default the property component
        System.out.println( "Testing example group properties..." );

        PropertyManager pm = (PropertyManager)ComponentFactory
            .getInstance( ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER );

        String key = "talon.component.1";
        
        PropertyManager group = pm.getGroup( key );

        System.out.println( "Found the following properties for key: " + key );

        Enumeration keys = group.getKeys();
        
        while ( keys.hasMoreElements() ) {

            String name = (String)keys.nextElement();
            String value = group.getString( name );
            System.out.println( name + "\t" + value );
            
        } 
        
    }

}
