/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.arrowhead.testlet.*;

import talon.*;
import talon.components.*;

/**
 * Get the default property component and make sure we have required properties.
 * Also output the componentReference and typeReference.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test2.java,v 1.7 2001/04/14 18:03:50 burton Exp $
 */
public class Test2 extends AbstractTestlet {


    public void initialize( TestletContext context ) throws Exception {

        //get default the property component

        ComponentHandle ch = new ComponentHandle( "talon.components.Logger",
                                                  "talon.implementations.SimpleLogger" );
        
        ch.getInitProperties().setProperty( "project", "Test2" );
        ch.getInitProperties().setBoolean( "stdout", true );
        
        Component comp = ComponentFactory.getInstance( ch );

        Logger logger = (Logger)comp;

        logger.message( this, "Using Component Reference URI: " + logger.getComponentReference() );
        logger.message( this, "Using Type Reference URI: " + logger.getTypeReference() );
        
    }

}
