/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.references;

import java.io.*;
import java.net.*;
import java.util.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Handles creating references for Components and ComponentHandles.
 *
 * @see Component
 * @see ComponentHandle
 * @see #Component.getComponentReference
 * @see #Component.getTypeReference
 * @see #ComponentHandle.getTypeReference
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: TypeReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
 */
public class TypeReferenceFactory extends ReferenceFactory {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: TypeReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
     */
    public static URI getTypeReference( Component component ) {

        //try to use the known interfaces...

        ComponentHandle handle = component.getComponentHandle();
        
        String interfaceURIPart = buildInterfaceURIPart( getInterfaces( component.getClass() ) ); 
            
        return getTypeReference( component.getClass().getName(), interfaceURIPart );

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: TypeReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
     */
    public static URI getTypeReference( ComponentHandle handle ) {

        try {

            Class clazz = Class.forName( handle.getImplementation() );

            Class[] interfaces = getInterfaces( clazz );

            return getTypeReference( handle.getImplementation(), buildInterfaceURIPart( interfaces ) );
            
        } catch ( Throwable t ) {

            //if for some reason we can't instantiate this... just use the
            //default (which may be null.
            return getTypeReference( handle.getImplementation(), "/interface/" + handle.getInterface() );
        }
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: TypeReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
     */
    public static URI getTypeReference( Class clazz ) {

        Class[] interfaces = getInterfaces( clazz );

        return getTypeReference( clazz.getName(), buildInterfaceURIPart( interfaces ) );
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: TypeReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
     */
    protected static URI getTypeReference( String implementation, String interfaceURIPart) {

        return new URI( "talon-type-reference:///component/" + implementation + interfaceURIPart );

    }

    
}
