/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.references;

import java.io.*;
import java.net.*;
import java.util.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Handles creating references for Components and ComponentHandles.
 *
 * @see Component
 * @see ComponentHandle
 * @see #Component.getComponentReference
 * @see #Component.getTypeReference
 * @see #ComponentHandle.getTypeReference
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ComponentReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
 */
public class ComponentReferenceFactory extends ReferenceFactory {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: ComponentReferenceFactory.java,v 1.4 2001/04/14 18:03:50 burton Exp $
     */
    public static URI getComponentReference( Component component ) {

        String host = null;

        try { 

            InetAddress address = InetAddress.getLocalHost();

            try {
                host = address.getHostName();
            } catch ( SecurityException e ) {
                address.getAddress();
            }

        } catch ( UnknownHostException uhe ) {
            host = "localhost";
        }

        String _implementation = component.getComponentHandle().getImplementation();
        String _interface = component.getComponentHandle().getInterface();

        Class[] interfaces = getInterfaces( component.getClass() );
                
        return new URI( "talon-component-reference://" + host + "/component/" + _implementation + buildInterfaceURIPart( interfaces ) + "/hashcode/" + component.hashCode() );
            
    }
    
    
}
