/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import talon.*;
import talon.Component;
import talon.components.*;
import talon.components.exceptions.*;
import talon.util.net.*;

/**
 * Simple database connection pool.  Only handles one instance.  Should only be
 * used for single threaded applications.  
 * 
 * @see DatabaseConnectionPool
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleDatabaseConnectionPool.java,v 1.5 2001/04/14 18:03:49 burton Exp $
 */
public class SimpleDatabaseConnectionPool extends BaseComponent implements Component,
                                                                           DatabaseConnectionPool {

    public static final String JDBC_URL = "jdbc_url";
    public static final String JDBC_DRIVER = "jdbc_driver";
    public static final String JDBC_USER = "jdbc_user";
    public static final String JDBC_PASS = "jdbc_pass";

    public static final String[] REQUIRED_PROPERTIES = { JDBC_URL, JDBC_DRIVER, JDBC_USER, JDBC_PASS };

    private Connection connection = null;
    
    public void init() throws TalonException {
        //add init code here

        this.getComponentHandle().getInitProperties().require( REQUIRED_PROPERTIES );

        PropertyManager pm = getComponentHandle().getInitProperties();
        
        String jdbc_url = pm.getString( JDBC_URL );
        String jdbc_driver = pm.getString( JDBC_DRIVER );
        String jdbc_user = pm.getString( JDBC_USER );
        String jdbc_pass = pm.getString( JDBC_PASS );

        Logger logger = getLogger();
        
        try { 

            logger.message( "Instantiating JDBC driver..." );
            
            Class.forName( jdbc_driver );

        } catch ( Throwable t ) {
            throw new TalonException( t );
        }

        logger.message( "Connecting... to: " + jdbc_url );
        logger.debug( this, JDBC_USER + " == " + jdbc_user );
        logger.debug( this, JDBC_PASS + " == " + jdbc_pass );
        
        try {

            this.connection = DriverManager.getConnection( jdbc_url, jdbc_user, jdbc_pass );
            
            //Statement stmt = con.createStatement();

        } catch ( SQLException se ) {

            TalonException te = new TalonException( se );

            te.setMessage( "message: " + se.getMessage() + ", " +
                           "state: " + se.getSQLState() + ", " +
                           "errorCode: " + se.getErrorCode() );
            
            throw te;

        }
        
    }
    
    /**
     * Call when you need a connetion.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleDatabaseConnectionPool.java,v 1.5 2001/04/14 18:03:49 burton Exp $
     */
    public synchronized Connection getConnection() {
        return this.connection;
    }

    /**
     * Call when you are done with a connection.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleDatabaseConnectionPool.java,v 1.5 2001/04/14 18:03:49 burton Exp $
     */
    public synchronized void releaseConnection( Connection connection ) {  
        //noop
    }
    
}
