/*
 * Decompiled with CFR 0.152.
 */
package talon.util;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import talon.BaseComponent;
import talon.Component;
import talon.components.PropertyManager;
import talon.components.exceptions.RequiredPropertyException;
import talon.implementations.SimplePropertyManager;

public abstract class BasePropertyManager
extends BaseComponent
implements Component,
PropertyManager {
    private Hashtable props = new Hashtable();

    public Object getProperty(String string) {
        return this.props.get(string);
    }

    public Object getProperty(String string, Object object) {
        Object object2 = (String)this.props.get(string);
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return false;
        }
        return string2.equalsIgnoreCase("true");
    }

    public PropertyManager setBoolean(String string, boolean bl) {
        if (bl) {
            this.setProperty(string, "true");
        } else {
            this.setProperty(string, "false");
        }
        return this;
    }

    public PropertyManager setString(String string, String string2) {
        this.setProperty(string, string2);
        return this;
    }

    public String getString(String string) {
        return (String)this.getProperty(string);
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public Vector getVector(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((string2 = this.getString(string + "." + n)) != null) {
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public PropertyManager getGroup(String string) {
        Enumeration enumeration = this.getKeys();
        SimplePropertyManager simplePropertyManager = new SimplePropertyManager();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) != 0) continue;
            bl = false;
            Object object = this.getProperty(string2);
            string2 = string2.substring(string.length() + 1, string2.length());
            simplePropertyManager.setProperty(string2, object);
        }
        if (bl) {
            return null;
        }
        return simplePropertyManager;
    }

    public PropertyManager setProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException("Name and value must not be null");
        }
        this.props.put(string, object);
        return this;
    }

    public Enumeration getKeys() {
        return this.props.keys();
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public void require(String[] stringArray) throws RequiredPropertyException {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.props.containsKey(stringArray[n])) {
                throw new RequiredPropertyException("The required property for this component does not exist: " + stringArray[n]);
            }
            ++n;
        }
    }

    public boolean containsKey(String string) {
        return this.props.containsKey(string);
    }

    public boolean contains(Object object) {
        return this.props.containsKey(object);
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream printStream) {
        printStream.println(this.getPrettyPrint());
    }

    private String getPrettyPrint() {
        Enumeration enumeration = this.getKeys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- listing properties --\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getProperty(string);
            stringBuffer.append(string.toString() + " = " + object.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public int size() {
        return this.props.size();
    }

    public Integer getInteger(String string) {
        return (Integer)this.getProperty(string);
    }

    public Integer getInteger(String string, Integer n) {
        Integer n2 = this.getInteger(string);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    public PropertyManager setInteger(String string, Integer n) {
        this.setProperty(string, n);
        return this;
    }

    public PropertyManager setInteger(String string, int n) {
        return this.setInteger(string, new Integer(n));
    }

    public Long getLong(String string) {
        return (Long)this.getProperty(string);
    }

    public Long getLong(String string, Long l) {
        Long l2 = this.getLong(string);
        if (l2 == null) {
            l2 = l;
        }
        return l2;
    }

    public PropertyManager setLong(String string, Long l) {
        this.setProperty(string, l);
        return this;
    }

    public PropertyManager setLong(String string, long l) {
        return this.setLong(string, new Long(l));
    }
}

