/*
 * Decompiled with CFR 0.152.
 */
package talon.util;

import talon.TalonException;

public class Base64 {
    private static char[] base64Alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '~', '-'};
    private static byte[] base64Reverse = new byte[128];

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, false);
    }

    public static String encode(byte[] byArray, boolean bl) {
        int n;
        char[] cArray = new char[(byArray.length + 2) / 3 * 4];
        int n2 = byArray.length % 3;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            n = (byArray[n4++] & 0xFF) << 16;
            if (n4 < byArray.length) {
                n |= (byArray[n4++] & 0xFF) << 8;
            }
            if (n4 < byArray.length) {
                n |= byArray[n4++] & 0xFF;
            }
            cArray[n3++] = base64Alphabet[n >> 18 & 0x3F];
            cArray[n3++] = base64Alphabet[n >> 12 & 0x3F];
            cArray[n3++] = base64Alphabet[n >> 6 & 0x3F];
            cArray[n3++] = base64Alphabet[n & 0x3F];
        }
        n = cArray.length;
        switch (n2) {
            case 1: {
                n -= 2;
                break;
            }
            case 2: {
                --n;
            }
        }
        if (bl) {
            while (n < cArray.length) {
                cArray[n++] = 95;
            }
        }
        return new String(cArray, 0, n);
    }

    public static byte[] decode(String string) throws TalonException {
        try {
            int n;
            int n2;
            byte by;
            byte by2;
            int n3;
            int n4;
            char[] cArray = string.toCharArray();
            int n5 = cArray.length;
            while (n5 > 0 && cArray[n5 - 1] == '_') {
                --n5;
            }
            int n6 = n5 / 4;
            int n7 = n5 & 3;
            int n8 = n6 * 4;
            int n9 = n4 = n6 * 3;
            switch (n7) {
                case 1: {
                    throw new TalonException("illegal Base64 length");
                }
                case 2: {
                    n9 = n4 + 1;
                    break;
                }
                case 3: {
                    n9 = n4 + 2;
                    break;
                }
                default: {
                    n9 = n4;
                }
            }
            byte[] byArray = new byte[n9];
            int n10 = 0;
            int n11 = 0;
            while (n11 < n8) {
                n3 = base64Reverse[cArray[n11]];
                by2 = base64Reverse[cArray[n11 + 1]];
                by = base64Reverse[cArray[n11 + 2]];
                n2 = base64Reverse[cArray[n11 + 3]];
                n = n3 | by2 | by | n2;
                if ((n & 0x80) != 0) {
                    throw new TalonException("illegal Base64 character");
                }
                int n12 = n3 << 18 | by2 << 12 | by << 6 | n2;
                byArray[n10] = (byte)(n12 >> 16);
                byArray[n10 + 1] = (byte)(n12 >> 8);
                byArray[n10 + 2] = (byte)n12;
                n11 += 4;
                n10 += 3;
            }
            switch (n7) {
                case 2: {
                    by2 = base64Reverse[cArray[n11]];
                    by = base64Reverse[cArray[n11 + 1]];
                    n3 = by2 | by;
                    n2 = by2 << 18 | by << 12;
                    byArray[n10] = (byte)(n2 >> 16);
                    break;
                }
                case 3: {
                    by2 = base64Reverse[cArray[n11]];
                    by = base64Reverse[cArray[n11 + 1]];
                    n2 = base64Reverse[cArray[n11 + 2]];
                    n3 = by2 | by | n2;
                    n = by2 << 18 | by << 12 | n2 << 6;
                    byArray[n10] = (byte)(n >> 16);
                    byArray[n10 + 1] = (byte)(n >> 8);
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if ((n3 & 0x80) != 0) {
                throw new TalonException("illegal Base64 character");
            }
            return byArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new TalonException("illegal Base64 character");
        }
    }

    static {
        int n = 0;
        while (n < base64Reverse.length) {
            Base64.base64Reverse[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < base64Alphabet.length) {
            Base64.base64Reverse[Base64.base64Alphabet[n2]] = (byte)n2;
            ++n2;
        }
    }
}

