/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import talon.BaseComponent;
import talon.Component;
import talon.TalonException;
import talon.components.DatabaseConnectionPool;
import talon.components.Logger;
import talon.components.PropertyManager;

public class SimpleDatabaseConnectionPool
extends BaseComponent
implements Component,
DatabaseConnectionPool {
    public static final String JDBC_URL = "jdbc_url";
    public static final String JDBC_DRIVER = "jdbc_driver";
    public static final String JDBC_USER = "jdbc_user";
    public static final String JDBC_PASS = "jdbc_pass";
    public static final String[] REQUIRED_PROPERTIES = new String[]{"jdbc_url", "jdbc_driver", "jdbc_user", "jdbc_pass"};
    private Connection connection = null;

    public void init() throws TalonException {
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        PropertyManager propertyManager = this.getComponentHandle().getInitProperties();
        String string = propertyManager.getString(JDBC_URL);
        String string2 = propertyManager.getString(JDBC_DRIVER);
        String string3 = propertyManager.getString(JDBC_USER);
        String string4 = propertyManager.getString(JDBC_PASS);
        Logger logger = this.getLogger();
        try {
            logger.message("Instantiating JDBC driver...");
            Class.forName(string2);
        }
        catch (Throwable throwable) {
            throw new TalonException(throwable);
        }
        logger.message("Connecting... to: " + string);
        logger.debug(this, "jdbc_user == " + string3);
        logger.debug(this, "jdbc_pass == " + string4);
        try {
            this.connection = DriverManager.getConnection(string, string3, string4);
        }
        catch (SQLException sQLException) {
            TalonException talonException = new TalonException(sQLException);
            talonException.setMessage("message: " + sQLException.getMessage() + ", " + "state: " + sQLException.getSQLState() + ", " + "errorCode: " + sQLException.getErrorCode());
            throw talonException;
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public synchronized void releaseConnection(Connection connection) {
    }
}

