/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.io.PrintStream;
import java.util.Enumeration;
import talon.BaseComponent;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.NotFoundException;
import talon.TalonException;
import talon.components.Logger;
import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;

public class HandleManager
extends BaseComponent {
    private static SimplePropertyManager byName = new SimplePropertyManager();
    private static SimplePropertyManager byInterface = new SimplePropertyManager();
    private static SimplePropertyManager byImplementation = new SimplePropertyManager();

    public void init() throws TalonException {
    }

    public static void registerComponentHandle(ComponentHandle componentHandle) throws TalonException {
        Logger logger = ComponentFactory.getLogger();
        logger.message("registering handle:" + componentHandle.toString());
        if (componentHandle.getName() != null) {
            logger.message("registering handle (byName):" + componentHandle.toString());
            HandleManager.registerComponentHandle(byName, componentHandle.getName(), componentHandle);
        }
        if (componentHandle.getInterface() != null) {
            logger.message("registering handle (byInterface):" + componentHandle.toString());
            HandleManager.registerComponentHandle(byInterface, componentHandle.getInterface(), componentHandle);
        }
        if (componentHandle.getImplementation() != null) {
            logger.message("registering handle (byImplementation):" + componentHandle.toString());
            HandleManager.registerComponentHandle(byImplementation, componentHandle.getImplementation(), componentHandle);
        }
    }

    private static void registerComponentHandle(SimplePropertyManager simplePropertyManager, String string, ComponentHandle componentHandle) throws TalonException {
        if (simplePropertyManager.contains(string)) {
            throw new TalonException("HandleManager already contains this component: " + componentHandle.toString());
        }
        simplePropertyManager.setProperty(string, componentHandle);
    }

    public static ComponentHandle byName(String string) throws TalonException {
        ComponentHandle componentHandle = (ComponentHandle)byName.getProperty(string);
        if (componentHandle == null) {
            throw new NotFoundException("ComponentHandle not found: " + string);
        }
        return componentHandle;
    }

    public static ComponentHandle byInterface(String string) throws TalonException {
        return (ComponentHandle)byInterface.getProperty(string);
    }

    public static ComponentHandle byImplementation(String string) throws TalonException {
        ComponentHandle componentHandle = (ComponentHandle)byImplementation.getProperty(string);
        if (componentHandle == null) {
            throw new NotFoundException("ComponentHandle not found: " + string);
        }
        return componentHandle;
    }

    public static ComponentHandle byImplementation(Class clazz) throws TalonException {
        return HandleManager.byImplementation(clazz.getName());
    }

    static PropertyManager getNameRegistry() {
        return byName;
    }

    static PropertyManager getInterfaceRegistry() {
        return byInterface;
    }

    static PropertyManager getImplementationRegistry() {
        return byImplementation;
    }

    public static void dump() {
        HandleManager.dump(System.out);
    }

    public static void dump(PrintStream printStream) {
        printStream.println(" --- BEGIN Dumping HandleManager --- ");
        HandleManager.dump(printStream, byName, "\n\n\n\tBY NAME\n\n\n");
        HandleManager.dump(printStream, byInterface, "\n\n\n\tBY INTERFACE\n\n\n");
        HandleManager.dump(printStream, byImplementation, "\n\n\n\tBY IMPLEMENTATION\n\n\n");
        printStream.println(" --- END Dumping HandleManager --- ");
    }

    private static void dump(PrintStream printStream, SimplePropertyManager simplePropertyManager, String string) {
        printStream.println(string);
        Enumeration enumeration = simplePropertyManager.getKeys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = simplePropertyManager.getProperty(e.toString());
            printStream.print("\t\t");
            printStream.println(e.toString());
            printStream.print("\t\t");
            printStream.println(object.toString());
            printStream.println();
            ((ComponentHandle)object).getInitProperties().dump(printStream);
        }
    }
}

