/*
 * Decompiled with CFR 0.152.
 */
package talon;

import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;
import talon.references.TypeReferenceFactory;
import talon.util.net.URI;

public class ComponentHandle {
    public static final String DEPLOY_PROPERTY_INTERFACE = "talon_interface";
    public static final String DEPLOY_PROPERTY_IMPLEMENTATION = "talon_implementation";
    public static final String DEPLOY_PROPERTY_LIFETIME = "talon_lifetime";
    public static final String DEPLOY_PROPERTY_NAME = "talon_name";
    public static final String DEPLOY_PROPERTY_DESCRIPTION = "talon_description";
    public static final String LIFETIME_DEMAND = "demand";
    public static final String LIFETIME_SINGLETON = "singleton";
    private String _interface = null;
    private String _implementation = null;
    private String _lifetime = null;
    private String _description = null;
    private URI typeReference = null;
    private PropertyManager initProperties = new SimplePropertyManager();
    private String name = null;

    public ComponentHandle() {
    }

    public ComponentHandle(String string) {
        this._interface = string;
    }

    public ComponentHandle(String string, String string2) {
        this(string);
        this._implementation = string2;
    }

    public ComponentHandle(String string, String string2, PropertyManager propertyManager) {
        this(string, string2);
        this.initProperties = propertyManager;
    }

    public ComponentHandle(String string, String string2, String string3, PropertyManager propertyManager) {
        this(string2, string3, propertyManager);
        this.setName(string);
    }

    public String getInterface() {
        return this._interface;
    }

    public ComponentHandle setInterface(String string) {
        this._interface = string;
        return this;
    }

    public String getImplementation() {
        return this._implementation;
    }

    public ComponentHandle setImplementation(String string) {
        this._implementation = string;
        return this;
    }

    public ComponentHandle setImplementation(Class clazz) {
        this.setImplementation(clazz.getName());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ComponentHandle setName(String string) {
        this.name = string;
        return this;
    }

    public String getLifetime() {
        return this._lifetime;
    }

    public ComponentHandle setLifetime(String string) {
        this._lifetime = string;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public ComponentHandle setDescription(String string) {
        this._description = string;
        return this;
    }

    public PropertyManager getInitProperties() {
        return this.initProperties;
    }

    public ComponentHandle setInitProperties(PropertyManager propertyManager) {
        this.initProperties = propertyManager;
        return this;
    }

    public String toString() {
        return this.getTypeReference().toString();
    }

    public URI getTypeReference() {
        if (this.typeReference == null) {
            this.typeReference = TypeReferenceFactory.getTypeReference(this);
        }
        return this.typeReference;
    }

    public Object clone() {
        ComponentHandle componentHandle = new ComponentHandle();
        componentHandle.setName(this.getName());
        componentHandle.setDescription(this.getDescription());
        componentHandle.setLifetime(this.getLifetime());
        componentHandle.setInitProperties(this.getInitProperties());
        componentHandle.setInterface(this.getInterface());
        componentHandle.setImplementation(this.getImplementation());
        return componentHandle;
    }
}

