/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.util.Hashtable;
import talon.Component;
import talon.ComponentHandle;
import talon.HandleManager;
import talon.Initializer;
import talon.TalonException;
import talon.components.Logger;
import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;

public class ComponentFactory {
    public static final String LIFETIME_SINGLETON = "singleton";
    public static final String LIFETIME_DEMAND = "demand";
    public static final ComponentHandle TALON_DEFAULT_LOGGER = new ComponentHandle().setName("TALON_DEFAULT_LOGGER").setInterface("talon.components.Logger").setImplementation("talon.implementations.SimpleLogger").setInitProperties(new SimplePropertyManager().setProperty("project", "talon")).setLifetime("singleton");
    public static final ComponentHandle TALON_DEFAULT_PROPERTY_MANAGER = new ComponentHandle().setName("TALON_DEFAULT_PROPERTY_MANAGER").setInterface("talon.components.PropertyManager").setImplementation("talon.implementations.SimplePropertyManager").setInitProperties(new SimplePropertyManager().setProperty("project", "talon")).setLifetime("singleton");
    public static final ComponentHandle LOGGER_INTERFACE_KEY = new ComponentHandle("talon.components.Logger");
    public static final ComponentHandle PROPERTY_MANAGER_INTERFACE_KEY = new ComponentHandle("talon.components.PropertyManager");
    private static Hashtable singletons = new Hashtable();
    private static Logger logger = null;

    public static Component getInstance(Class clazz) throws TalonException {
        return ComponentFactory.getInstance(clazz.getName());
    }

    public static Component getInstance(String string) throws TalonException {
        return ComponentFactory.getInstance(new ComponentHandle().setImplementation(string).setLifetime(LIFETIME_DEMAND));
    }

    public static Component getInstance(ComponentHandle componentHandle) throws TalonException {
        Initializer.init();
        if (componentHandle.getLifetime() == null) {
            componentHandle.setLifetime(LIFETIME_DEMAND);
        }
        ComponentFactory.constrain(componentHandle.getName(), componentHandle, HandleManager.getNameRegistry());
        ComponentFactory.constrain(componentHandle.getImplementation(), componentHandle, HandleManager.getImplementationRegistry());
        if (componentHandle.getImplementation() == null) {
            throw new TalonException("Unable to determine implementation classname.");
        }
        String string = componentHandle.getLifetime();
        if (string.equals(LIFETIME_DEMAND)) {
            return ComponentFactory.getDemandBasedInstance(componentHandle);
        }
        if (string.equals(LIFETIME_SINGLETON)) {
            return ComponentFactory.getSingletonBasedInstance(componentHandle);
        }
        throw new TalonException("Do not know how to create " + componentHandle.toString());
    }

    private static void constrain(String string, ComponentHandle componentHandle, PropertyManager propertyManager) {
        if (string != null && propertyManager.containsKey(string)) {
            ComponentHandle componentHandle2 = (ComponentHandle)propertyManager.getProperty(string);
            ComponentFactory.constrain(componentHandle, componentHandle2);
        }
    }

    private static void constrain(ComponentHandle componentHandle, ComponentHandle componentHandle2) {
        if (componentHandle2.getName() != null && componentHandle.getName() == null) {
            componentHandle.setName(componentHandle2.getName());
        }
        if (componentHandle2.getInterface() != null && componentHandle.getInterface() == null) {
            componentHandle.setInterface(componentHandle2.getInterface());
        }
        if (componentHandle2.getImplementation() != null && componentHandle.getImplementation() == null) {
            componentHandle.setImplementation(componentHandle2.getImplementation());
        }
        if (componentHandle.getInitProperties().size() == 0 && componentHandle2.getInitProperties().size() != 0) {
            logger.debug("Handle provided doesn't have any properties.");
            componentHandle.setInitProperties(componentHandle2.getInitProperties());
        }
    }

    private static Component getDemandBasedInstance(ComponentHandle componentHandle) throws TalonException {
        return ComponentFactory.instantiateComponent(componentHandle);
    }

    private static Component getSingletonBasedInstance(ComponentHandle componentHandle) throws TalonException {
        Component component = (Component)singletons.get(componentHandle);
        if (component == null) {
            component = ComponentFactory.instantiateComponent(componentHandle);
            ComponentFactory.putSingleton(componentHandle, component);
        }
        return component;
    }

    private static Component instantiateComponent(ComponentHandle componentHandle) throws TalonException {
        try {
            Component component = (Component)Class.forName(componentHandle.getImplementation()).newInstance();
            component.setComponentHandle(componentHandle);
            component.init();
            return component;
        }
        catch (Throwable throwable) {
            throw new TalonException(throwable);
        }
    }

    static void putSingleton(ComponentHandle componentHandle, Component component) {
        singletons.put(componentHandle, component);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        ComponentFactory.logger = logger;
    }
}

