/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.util.net;

/**
 * First class object for the W3C Schema concept of a uriReference.  
 *
 * TODO: use a regexp on the reference to verify it is a valid URI.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
 */
public class URI {

    private String reference = null;
    private boolean isURL = false;


    /**
     * Noop constructor if called as a bean.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public URI() { }

    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public URI( String reference ) {
        this.reference = reference;
    }

    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public URI( String reference,
                boolean isURL ) {

        this.reference = reference;
        this.isURL = isURL;

    }
    
    /**
     * @see Object.toString#
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public String toString() {
        return this.reference;
    }

    /**
     * @see Object
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public boolean equals( Object obj ) {

        if ( obj.getClass().equals( obj.getClass() ) ) {

            URI uri = (URI)obj;

            return uri.toString().equals( this.toString() );
            
        } 

        return false;
    }
    
    /**
     * Return true if this URL is network locatable.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public boolean isURL() {
        return this.isURL;
    }


    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public String getReference() { 
        return this.reference;
    }

    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public void setReference( String reference ) { 
        this.reference = reference;
    }

    /**
     * Return the scheme of this URL.  This is the portion of the URL before any
     * addressing portion.  This is usually expressed as
     * scheme://resource_location.  Example.  URI -> http://www.openprivacy.org
     * scheme ->  http
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: URI.java,v 1.4 2001/04/14 18:03:51 burton Exp $
     */
    public String getScheme() {

        String scheme = null;

        int index = this.reference.indexOf( ":" );

        if ( index != -1 ) {
            scheme = this.reference.substring( 0, index );
        } 
        
        return scheme;
        
    }
    
}


