/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.arrowhead.testlet.*;

import talon.*;
import talon.components.*;

/**
 * Get the Logger by multiple methods.  Use its log methods and make sure there
 * is no problem with output.  
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test3.java,v 1.7 2001/04/14 18:03:50 burton Exp $
 */
public class Test3 extends AbstractTestlet {

    public void initialize( TestletContext context ) throws Exception {

        //Get a PropertyManager Component via its handle in ComponentFactory
        PropertyManager pm = (PropertyManager)ComponentFactory
            .getInstance( ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER );

        //test the logging mechanism
        pm.getLogger().message( "It worked..." );


        testImplementation();
        
        testName();
        
    }

    private void testImplementation() throws Exception {

        //try to get a Component by its implementation
        ComponentHandle handle = HandleManager
            .byImplementation( talon.implementations.SimpleLogger.class );

        handle.getInitProperties().setString( "project", "talon" );
        
        
        ComponentFactory.getInstance( handle );

        
    }

    private void testName() throws Exception {

        //try to get a Component via its name
        ComponentHandle handle = HandleManager.byName( "default_logger" );
        ComponentFactory.getInstance( handle );

    }
    
}
