/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.references;

import java.io.*;
import java.net.*;
import java.util.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Handles creating references for Components and ComponentHandles.
 *
 * @see Component
 * @see ComponentHandle
 * @see #Component.getComponentReference
 * @see #Component.getTypeReference
 * @see #ComponentHandle.getTypeReference
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ReferenceFactory.java,v 1.3 2001/04/14 18:03:50 burton Exp $
 */
public class ReferenceFactory {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: ReferenceFactory.java,v 1.3 2001/04/14 18:03:50 burton Exp $
     */
    protected static String buildInterfaceURIPart( Class[] interfaces ) {

        StringBuffer interfaceURIPart = new StringBuffer();

        for ( int i = 0; i < interfaces.length; ++i ) {
            interfaceURIPart.append( "/interface/" );
            interfaceURIPart.append( interfaces[i].getName() );
        } 

        return interfaceURIPart.toString();
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: ReferenceFactory.java,v 1.3 2001/04/14 18:03:50 burton Exp $
     */
    public static Class[] getInterfaces( Class current ) {

        Vector knownInterfaces = new Vector();
            
        //go through every class and determine all known interfacs

        while ( current != null ) {

            Class[] interfaces = current.getInterfaces();
                
            for ( int i = 0; i < interfaces.length; ++i ) {

                if ( knownInterfaces.contains( interfaces[i] ) == false ){

                    knownInterfaces.addElement( interfaces[i] );                        

                } 

            } 
                
            current = current.getSuperclass();
                
        } 
            
        
        //go through all of these interfaces and if these are Component
        //interfaces add them.   
            
        //go over all knownInterfaces and remove any that don't apply.

        for ( int i = 0; i < knownInterfaces.size(); ++i ) {

            Class currentInterface = (Class)knownInterfaces.elementAt( i );

            //remove the talon.Component interface... we don't need this.
            if ( currentInterface.equals( talon.Component.class ) ||
                 currentInterface.getName().equals( talon.Component.class.getName() ) ) {

                knownInterfaces.removeElement( currentInterface );

            } 

            //make sure this isn't just a random class like Serializable, etc.
            //It must implement a Talon component.
            if ( ! Component.class.isAssignableFrom( currentInterface ) ) {

                knownInterfaces.removeElement( currentInterface );

            } 
            
        } 

        Class[] componentInterfaces = new Class[ knownInterfaces.size() ];
        knownInterfaces.copyInto( componentInterfaces );

        return componentInterfaces;

    }
    
}
