/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.components;

import java.util.*;

import talon.Component;


/**
 * Logger interface which can be used within an application for debug and
 * runtime information.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
 */
public interface Logger extends Component {


    /**
     * Log a message.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void message( String message );

    /**
     * Log a message.
     *
     * @param source The source object.  The classname of this object will be
     *               entered into the log
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void message( Object source, String message );
    
    /**
     * Log a message.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void debug( String message );

    /**
     * Log a debug message.
     *
     * @param source The source object.  The classname of this object will be
     *               entered into the log
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void debug( Object source, String message );
    
    /**
     * Log a warning message.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void warning( String message );
    
    /**
     * Log a warning message.
     *
     * @param source The source object.  The classname of this object will be
     *               entered into the log
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void warning( Object source, String message );
    
    /**
     * Log an error message.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void error( String message );

    /**
     * Log an error message.
     *
     * @param source The source object.  The classname of this object will be
     *               entered into the log
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void error( Object source, String message );

    /**
     * Log an Exception.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Logger.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void error( Throwable t );
    
}
