/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon.components;

import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import talon.*;
import talon.Component;
import talon.components.exceptions.*;
import talon.util.net.*;

/**
 * Handles database connections.  For a more detailed description of using
 * database pools see an implemntation class.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: DatabaseConnectionPool.java,v 1.2 2001/04/14 18:03:49 burton Exp $
 */
public interface DatabaseConnectionPool extends Component {

    /**
     * Call when you need a connetion.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: DatabaseConnectionPool.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public Connection getConnection();

    /**
     * Call when you are done with a connection.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: DatabaseConnectionPool.java,v 1.2 2001/04/14 18:03:49 burton Exp $
     */
    public void releaseConnection( Connection connection );
    
}
