/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package talon;

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*;

/**
 * Base Exception for Talon.  Allows Exceptions to be passed as a reason for why
 * this Exception was created.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: TalonException.java,v 1.8 2001/04/14 18:03:48 burton Exp $
 */
public class TalonException extends Exception {

    private Throwable reason = null;
    private String message = null;

    
    public TalonException() {
        super();
    }

    public TalonException( String message ) {
        setMessage( message );
    }

    public TalonException( Throwable reason ) {

        this( null, reason );
        
    }

    public TalonException( String message, Throwable reason ) {

        super( message );

        //if the given Exception is already a TalonException (or subclass) and
        //its reason is set use this one instead...  
        if ( reason instanceof TalonException ) {

            this.reason = ((TalonException)reason).getReason();
            
        } else {

            this.reason = reason;
            
        }

        //try to merge the current message if any...
        if ( message == null ) {
            message = this.reason.getMessage();
        } 
        
        this.setMessage( "See attached nested exeception ( " +
                         this.reason.getClass().getName() +
                         " ):  " +
                         message );
        
    }

    public void printStackTrace() {
        super.printStackTrace();

        if ( reason != null ) 
            reason.printStackTrace();            
    }

    public void printStackTrace(java.io.PrintStream s) { 
        super.printStackTrace( s );

        if ( reason != null ) 
            reason.printStackTrace( s );
    }
        
    public void printStackTrace(java.io.PrintWriter s) { 
        super.printStackTrace( s );

        if ( reason != null ) 
            reason.printStackTrace( s );
    }

    public Throwable getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage( String message ) {
        this.message = message;
    }
}
