/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import talon.BaseComponent;
import talon.Component;
import talon.ComponentHandle;
import talon.TalonException;
import talon.components.Logger;

public class SimpleLogger
extends BaseComponent
implements Component,
Logger {
    public static final String[] REQUIRED_PROPERTIES = new String[]{"project"};
    public static final String INIT_PROPERTY_FILE = "file";
    public static final String INIT_PROPERTY_DEBUG = "debug";
    public static final String INIT_PROPERTY_STDERR = "stdout";
    public static final String INIT_PROPERTY_STDOUT = "stdout";
    public static final String INIT_PROPERTY_PROJECT = "project";
    private boolean fileSafe = true;
    private String file = null;
    private PrintWriter fileOutput = null;
    private boolean debug = false;
    private boolean stdout = false;
    private boolean stderr = false;
    private String project = null;

    public SimpleLogger() {
    }

    public SimpleLogger(ComponentHandle componentHandle, boolean bl, boolean bl2, boolean bl3, String string) {
        this.setComponentHandle(componentHandle);
        this.debug = bl;
        this.stdout = bl2;
        this.stderr = bl3;
        this.project = string;
    }

    public void init() throws TalonException {
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        this.debug = this.getComponentHandle().getInitProperties().getBoolean(INIT_PROPERTY_DEBUG);
        this.stdout = this.getComponentHandle().getInitProperties().getBoolean("stdout");
        this.stderr = this.getComponentHandle().getInitProperties().getBoolean("stdout");
        this.file = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_FILE);
        this.project = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_PROJECT);
    }

    public void message(String string) {
        this.message(null, string);
    }

    public void message(Object object, String string) {
        this.logString(object, this.getLogPrefix() + " -> " + string);
    }

    public void error(String string) {
        this.error(null, string);
    }

    public void error(Object object, String string) {
        this.logString(object, this.getLogPrefix() + " -> ERROR: " + string);
    }

    public void warning(String string) {
        this.warning(null, string);
    }

    public void warning(Object object, String string) {
        this.logString(object, this.getLogPrefix() + " -> WARNING: " + string);
    }

    public void debug(String string) {
        this.debug(null, string);
    }

    public void debug(Object object, String string) {
        if (this.debug) {
            this.logString(object, this.getLogPrefix() + " -> DEBUG: " + string);
        }
    }

    private void logString(String string) {
        this.logString(null, string);
    }

    private void logString(Object object, String string) {
        if (object != null) {
            string = object.getClass().getName() + " : " + string;
        }
        if (this.stdout) {
            System.out.println(string);
        }
        if (this.stderr) {
            System.err.println(string);
        }
        if (this.isFileEnabled()) {
            if (this.fileOutput == null) {
                try {
                    this.fileOutput = new PrintWriter(new FileWriter(this.file, true));
                    this.debug("Logging to disk is enabled: " + this.file);
                }
                catch (Throwable throwable) {
                    this.fileSafe = false;
                    this.error(throwable.getMessage());
                }
            }
            this.fileOutput.println(string);
            this.fileOutput.flush();
        }
    }

    private String getLogPrefix() {
        return this.project + " [" + this.getDate() + "]";
    }

    private boolean isFileEnabled() {
        if (!this.fileSafe) {
            return false;
        }
        if (this.file == null) {
            return false;
        }
        File file = new File(this.file);
        boolean bl = file.exists();
        boolean bl2 = file.canWrite();
        boolean bl3 = this.fileSafe = bl && bl2;
        if (!bl) {
            this.error("Log file does not exist: " + this.file);
        } else if (!bl2) {
            this.error("Log file can not be written to: " + this.file);
        }
        return this.fileSafe;
    }

    private String getDate() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(calendar.get(2) + 1);
        stringBuffer.append("-");
        stringBuffer.append(calendar.get(5));
        stringBuffer.append("-");
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(calendar.get(10) + 1);
        stringBuffer.append(".");
        int n = calendar.get(12);
        if (n < 10) {
            stringBuffer.append(0);
        }
        stringBuffer.append(n);
        stringBuffer.append(".");
        stringBuffer.append(calendar.get(13));
        stringBuffer.append(".");
        stringBuffer.append(calendar.get(14));
        return stringBuffer.toString();
    }

    public void error(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        this.message(byteArrayOutputStream.toString());
    }
}

