/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Vector;
import talon.ComponentHandle;
import talon.TalonException;
import talon.util.BasePropertyManager;

public class FilePropertyManager
extends BasePropertyManager {
    public static final String[] REQUIRED_PROPERTIES = new String[]{"project"};
    public static final String INIT_PROPERTY_PROJECT = "project";
    private String propertyFilename = null;

    public FilePropertyManager() {
    }

    public FilePropertyManager(ComponentHandle componentHandle, String string) throws TalonException {
        this.setComponentHandle(componentHandle);
        componentHandle.getInitProperties().setProperty(INIT_PROPERTY_PROJECT, string);
        this.init();
    }

    public void init() throws TalonException {
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        String string = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_PROJECT);
        String[] stringArray = this.getFileLocations(string);
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (new File(stringArray[n]).exists()) {
                string2 = stringArray[n];
            }
            ++n;
        }
        if (string2 == null) {
            throw new TalonException("Unable to find a property file to use.");
        }
        this.propertyFilename = string2;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(string2));
            this.setProperties(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TalonException(exception.getMessage());
        }
    }

    private String[] getFileLocations(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = string.toUpperCase() + "_PROPERTIES";
        String string3 = System.getProperty(string2);
        if (string3 != null) {
            vector.addElement(string3);
        }
        vector.addElement(System.getProperty("user.home") + File.separator + string + ".properties");
        vector.addElement(System.getProperty("java.home") + File.separator + string + ".properties");
        vector.addElement("/etc/" + string + ".properties");
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }
}

