/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.util.Enumeration;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.HandleManager;
import talon.components.PropertyManager;
import talon.implementations.FilePropertyManager;
import talon.implementations.SimpleLogger;

public class Initializer {
    public static final String TALON_LOG_DEBUG_KEY = "talon.log.debug";
    public static final String TALON_LOG_STDOUT_KEY = "talon.log.stdout";
    public static final String TALON_LOG_STDERR_KEY = "talon.log.stderr";
    public static final String TALON_PROJECT_KEY = "talon.project";
    private static boolean initialized = false;
    private static boolean working = false;

    public static void init() {
        if (Initializer.shouldInitialize()) {
            working = true;
            try {
                String string;
                PropertyManager propertyManager;
                String string2 = System.getProperty(TALON_PROJECT_KEY);
                if (string2 == null) {
                    string2 = "talon";
                }
                FilePropertyManager filePropertyManager = new FilePropertyManager(ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER, string2);
                ComponentFactory.putSingleton(ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER, filePropertyManager);
                SimpleLogger simpleLogger = new SimpleLogger(ComponentFactory.TALON_DEFAULT_LOGGER, filePropertyManager.getBoolean(TALON_LOG_DEBUG_KEY), filePropertyManager.getBoolean(TALON_LOG_STDOUT_KEY), filePropertyManager.getBoolean(TALON_LOG_STDERR_KEY), filePropertyManager.getString(TALON_PROJECT_KEY));
                ComponentFactory.setLogger(simpleLogger);
                ComponentFactory.putSingleton(ComponentFactory.TALON_DEFAULT_LOGGER, simpleLogger);
                simpleLogger.message("Talon initialized via file " + filePropertyManager.getPropertyFilename());
                simpleLogger.message(filePropertyManager.toString());
                simpleLogger.message(((Object)simpleLogger).toString());
                simpleLogger.message("Creating handles for all deployed components...");
                int n = 0;
                while ((propertyManager = filePropertyManager.getGroup(string = "talon.component." + n)) != null) {
                    simpleLogger.debug("Building properties for: " + string);
                    ComponentHandle componentHandle = new ComponentHandle();
                    componentHandle.setName(propertyManager.getString("talon_name"));
                    componentHandle.setInterface(propertyManager.getString("talon_interface"));
                    componentHandle.setImplementation(propertyManager.getString("talon_implementation"));
                    componentHandle.setLifetime(propertyManager.getString("talon_lifetime"));
                    componentHandle.setDescription(propertyManager.getString("talon_description"));
                    Enumeration enumeration = propertyManager.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String string4 = propertyManager.getString(string3);
                        simpleLogger.debug("\t" + string3 + " = " + string4);
                        componentHandle.getInitProperties().setProperty(string3, string4);
                    }
                    simpleLogger.message(componentHandle.toString());
                    HandleManager.registerComponentHandle(componentHandle);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean isWorking() {
        return working;
    }

    public static boolean shouldInitialize() {
        return !Initializer.isWorking() && !Initializer.isInitialized();
    }
}

