<?xml version="1.0"?> 

<!--

$Id: maximize.xsl,v 1.2 2001/08/04 10:10:52 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Handles building the structure for this reputation-management session.

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:cm="http://schemas.openprivacy.org/reptile/channel-management"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                extension-element-prefixes="functions"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.channel-management.location" select="''"/>
    <xsl:param name="reptile.channel-management.contentType" select="''"/>
    <xsl:param name="reptile.channel-management.title" select="$reptile.channel-management.location"/>

    <xsl:template match="/cm:channel-management">

        <layout:layout>

            <layout:layer-index default="{$reptile.channel-management.title}">
        
                <layout:layer name="{$reptile.channel-management.title}" numColumns="1"/>
    
            </layout:layer-index>
    
    
            <layout:content contentType="{$reptile.channel-management.contentType}">
    
                <xsl:attribute name="location">
    
                    <xsl:value-of select="functions:decode( $reptile.channel-management.location )"/>
    
                </xsl:attribute>
    
                <layout:position column="left" layer="{$reptile.channel-management.title}"/>
    
            </layout:content>

        </layout:layout>

    </xsl:template>

</xsl:stylesheet>
