/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommandLineCompiler;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;

public class CommandLineContext
implements JspCompilationContext {
    String classPath;
    JspReader reader;
    ServletWriter writer;
    URLClassLoader loader;
    boolean errPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    String uriBase;
    File uriRoot;
    boolean outputInDirs;

    public CommandLineContext(String newClassPath, String newJspFile, String newUriBase, String newUriRoot, boolean newErrPage, Options newOptions) throws JasperException {
        this.classPath = newClassPath;
        this.uriBase = newUriBase;
        String tUriRoot = newUriRoot;
        this.jspFile = newJspFile;
        this.errPage = newErrPage;
        this.options = newOptions;
        if (this.uriBase == null) {
            this.uriBase = "/";
        } else if (this.uriBase.charAt(0) != '/') {
            this.uriBase = "/" + this.uriBase;
        }
        if (this.uriBase.charAt(this.uriBase.length() - 1) != '/') {
            this.uriBase = String.valueOf(this.uriBase) + '/';
        }
        if (tUriRoot == null) {
            this.uriRoot = new File("");
        } else {
            this.uriRoot = new File(tUriRoot);
            if (!this.uriRoot.exists() || !this.uriRoot.isDirectory()) {
                throw new JasperException(Constants.getString((String)"jsp.error.jspc.uriroot_not_dir"));
            }
        }
    }

    public Compiler createCompiler() throws JasperException {
        return new CommandLineCompiler(this);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getJavacOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public String getRealPath(String path) {
        if ((path = this.resolveRelativeUri(path)).startsWith("/")) {
            path = path.substring(1);
        }
        File f = new File(this.uriRoot, path.replace('/', File.separatorChar));
        return f.getAbsolutePath();
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.loader.getResource(res);
    }

    public InputStream getResourceAsStream(String res) {
        InputStream in;
        try {
            in = new FileInputStream(this.getRealPath(res));
        }
        catch (IOException iOException) {
            in = null;
        }
        if (in == null) {
            try {
                in = new FileInputStream(res);
            }
            catch (IOException iOException) {
                in = null;
            }
        }
        if (in == null) {
            in = ((ClassLoader)this.loader).getResourceAsStream(res);
        }
        return in;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.options.getTldLocationsCache().getLocation(uri);
        return location;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public boolean isErrorPage() {
        return this.errPage;
    }

    public boolean isOutputInDirs() {
        return this.outputInDirs;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return String.valueOf(this.uriBase) + uri;
    }

    public void setClassLoader(URLClassLoader loader) {
        this.loader = loader;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setErrorPage(boolean isErrPage) {
        this.errPage = isErrPage;
    }

    public void setOutputInDirs(boolean newValue) {
        this.outputInDirs = true;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }
}

