/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import talon.BaseComponent;
import talon.Component;
import talon.TalonException;
import talon.components.DatabaseConnectionPool;
import talon.components.Logger;
import talon.components.PropertyManager;

public class SimpleDatabaseConnectionPool
extends BaseComponent
implements Component,
DatabaseConnectionPool {
    public static final String JDBC_URL = "jdbc_url";
    public static final String JDBC_DRIVER = "jdbc_driver";
    public static final String JDBC_USER = "jdbc_user";
    public static final String JDBC_PASS = "jdbc_pass";
    public static final String[] REQUIRED_PROPERTIES;
    private Connection connection = null;

    public void init() throws TalonException {
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        PropertyManager pm = this.getComponentHandle().getInitProperties();
        String jdbc_url = pm.getString(JDBC_URL);
        String jdbc_driver = pm.getString(JDBC_DRIVER);
        String jdbc_user = pm.getString(JDBC_USER);
        String jdbc_pass = pm.getString(JDBC_PASS);
        Logger logger = this.getLogger().getLogger(this.getClass());
        try {
            logger.debug("Instantiating JDBC driver...");
            Class.forName(jdbc_driver);
        }
        catch (Throwable t) {
            throw new TalonException(t);
        }
        logger.debug("Connecting... to: " + jdbc_url);
        logger.debug("jdbc_user == " + jdbc_user);
        logger.debug("jdbc_pass == " + jdbc_pass);
        try {
            this.connection = DriverManager.getConnection(jdbc_url, jdbc_user, jdbc_pass);
        }
        catch (SQLException se) {
            TalonException te = new TalonException(se);
            te.setMessage("message: " + se.getMessage() + ", " + "state: " + se.getSQLState() + ", " + "errorCode: " + se.getErrorCode());
            throw te;
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public synchronized void releaseConnection(Connection connection) {
    }

    static {
        JDBC_URL = JDBC_URL;
        JDBC_DRIVER = JDBC_DRIVER;
        JDBC_USER = JDBC_USER;
        JDBC_PASS = JDBC_PASS;
        REQUIRED_PROPERTIES = new String[]{JDBC_URL, JDBC_DRIVER, JDBC_USER, JDBC_PASS};
    }
}

