/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.jxta;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.jxta.JXTATLSDefs;
import COM.claymoresystems.ptls.jxta.JXTATLSRecord;
import COM.claymoresystems.ptls.jxta.JXTATLSutil;
import COM.claymoresystems.ptls.jxta.Message;
import COM.claymoresystems.ptls.jxta.MessageElement;
import COM.claymoresystems.ptls.jxta.MessageImpl;
import COM.claymoresystems.ptls.jxta.MessageWireFormat;
import COM.claymoresystems.ptls.jxta.MessageWireFormatBinary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class JXTAInputStream
extends InputStream {
    private JXTATLSRecord jtrec = null;
    private MessageWireFormat wireIn = null;
    private Message jmsg = null;
    private int sequenceNumber = 0;
    private Vector inputElements = new Vector(10, 1);
    private InputStream plain_in = null;
    private MessageElement currentElt = null;
    private Socket sock = null;
    private InputStream netIn = null;
    private OutputStream netOut = null;
    private int listenPort = 0;

    public JXTAInputStream() {
        this.jtrec = new JXTATLSRecord();
        this.jmsg = new MessageImpl();
        this.wireIn = new MessageWireFormatBinary(JXTATLSDefs.MTYPE);
        this.sequenceNumber = 0;
        this.plain_in = null;
    }

    public MessageWireFormat getMessageWireFormat() {
        return this.wireIn;
    }

    public void setPlaintextInputStream(SSLSocket sSLSocket) {
        this.plain_in = sSLSocket.getInputStream();
    }

    private int netRead(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = this.netIn.read(byArray, n, byArray.length - n);
            if (n2 == -1) {
                return -1;
            }
            n += n2;
        }
        return n;
    }

    public int readMessage(MessageWireFormat messageWireFormat, Message message) {
        try {
            messageWireFormat.readMessage(this.plain_in, message);
        }
        catch (IOException iOException) {
            System.out.println("IOException in JXTAInputStream.readMessage:\n  " + iOException.getMessage());
            return -1;
        }
        return 0;
    }

    private MessageElement getNextElement() {
        MessageElement messageElement = null;
        MessageElement messageElement2 = null;
        MessageElement messageElement3 = null;
        while ((messageElement = JXTATLSutil.getNextElement(this.jmsg, messageElement2)) != null) {
            int n = this.getSequenceNumber(messageElement);
            if (n == this.sequenceNumber) {
                messageElement3 = messageElement;
                if (SSLDebug.getDebug(128)) {
                    System.out.println("Return# " + n);
                }
            } else if (n > this.sequenceNumber) {
                this.inputElements.add(messageElement);
                if (SSLDebug.getDebug(128)) {
                    System.out.println("queued# " + n);
                }
            } else {
                if (SSLDebug.getDebug(128)) {
                    System.out.println("Duplicate msg received, initial seq# " + n);
                }
                return null;
            }
            messageElement2 = messageElement;
        }
        return messageElement3;
    }

    private int getSequenceNumber(MessageElement messageElement) {
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        Integer n = new Integer(string2);
        return n;
    }

    private MessageElement getVectorElement() {
        int n = this.inputElements.size();
        int n2 = 0;
        while (n2 < n) {
            MessageElement messageElement = (MessageElement)this.inputElements.elementAt(n2);
            int n3 = this.getSequenceNumber(messageElement);
            if (n3 == this.sequenceNumber) {
                this.inputElements.removeElementAt(n2);
                return messageElement;
            }
            ++n2;
        }
        return null;
    }

    private int local_read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.jtrec.size == 0 || this.jtrec.nextByte == this.jtrec.size) {
            this.jtrec.resetRecord();
            ++this.sequenceNumber;
            this.currentElt = this.getVectorElement();
            if (this.currentElt == null) {
                try {
                    while (this.currentElt == null) {
                        this.wireIn.readMessage(this.netIn, this.jmsg);
                        this.currentElt = this.getNextElement();
                        JXTATLSutil.removeElements(this.jmsg);
                    }
                }
                catch (IOException iOException) {
                    if (SSLDebug.getDebug(128)) {
                        System.out.println(iOException.getMessage());
                    }
                    return -1;
                }
            }
            SSLDebug.debug(8, "Rcvd MELT");
            this.jtrec.size = this.currentElt.getLength();
            if (SSLDebug.getDebug(128)) {
                System.out.println("local_read: seq#" + this.sequenceNumber + ", bytes = " + this.jtrec.size + "\n");
            }
            this.jtrec.tlsRecord = this.currentElt.getBytesOffset();
            SSLDebug.debug(2, "Rcvd TLS Record[" + this.jtrec.size + " bytes]");
        }
        int n4 = (n3 = this.jtrec.size - this.jtrec.nextByte) < n2 ? n3 : n2;
        System.arraycopy(this.jtrec.tlsRecord, this.jtrec.nextByte, byArray, n, n4);
        this.jtrec.nextByte += n4;
        SSLDebug.debug(8, "\nRequested " + n2 + ", Read " + n4 + " bytes");
        return n4;
    }

    public JXTAInputStream(int n) {
        this.listenPort = n;
        this.jtrec = new JXTATLSRecord();
        this.jmsg = new MessageImpl();
        this.wireIn = new MessageWireFormatBinary(JXTATLSDefs.MTYPE);
        this.sequenceNumber = 0;
    }

    public int accept() throws IOException {
        if (this.listenPort != 0) {
            ServerSocket serverSocket = new ServerSocket(this.listenPort);
            this.sock = serverSocket.accept();
            this.netIn = this.sock.getInputStream();
            this.netOut = this.sock.getOutputStream();
            return 0;
        }
        return -1;
    }

    public void closeNetSocket() throws IOException {
        this.sock.close();
    }

    public OutputStream getNetOutputStream() {
        return this.netOut;
    }

    public void setNetInputStream(InputStream inputStream) {
        this.netIn = inputStream;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.local_read(byArray, 0, 1);
        SSLDebug.debug(8, "Read()", byArray);
        if (n != -1) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.local_read(byArray, n, n2);
        SSLDebug.debug(8, "Read(byte[], int, int)", byArray);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.local_read(byArray, 0, byArray.length);
        return n;
    }
}

