/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLServerSocket;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.demo.Demo;
import COM.claymoresystems.sslg.SSLPolicyInt;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;

class SSLServer {
    private static int port = 4433;
    private static String keyfile = "server.pem";
    private static String rootfile = "root.pem";
    private static String password = "password";
    private static LongOpt[] Longopts = new LongOpt[11];
    private static boolean clientauth = false;
    private static boolean renegotiate = false;
    private static boolean fakeseed = false;
    private static short[] cipherSuites = null;
    private static int iterate = -1;
    private static String dhfile = null;

    SSLServer() {
    }

    private static void webServe(SSLSocket sSLSocket) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(sSLSocket.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(sSLSocket.getOutputStream());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        do {
            if ((string = bufferedReader.readLine()) == null) {
                return;
            }
            string.trim();
        } while (string.length() > 0);
        bufferedWriter.write("HTTP/1.0 200 OK\r\n");
        bufferedWriter.write("Server: PureTLS Demo Server\r\n");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("Success!\r\n");
        bufferedWriter.flush();
        sSLSocket.close();
    }

    private static void usage() {
        System.out.println("SSLClient usage ");
        System.out.println("SSLClient [args]");
        System.out.println("  --port, -h: the port to connect to (default 4433)");
        System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
        System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
        System.out.println("  --password, -P: the password to use (default password)");
        System.out.println("  --clientauth, -c: require client authentication");
        System.out.println("  --renegotiate, -C: negotiate w/o client auth and then");
        System.out.println("    renegotiate with");
        System.out.println("  --debug, -d: set the debugging flags");
        System.out.println("  --fakerandom, -f: seed the rng with null data");
        System.out.println("  --iterate, -i: Allow X connections before exiting");
        System.out.println("  --ciphersuites, -a: allowed ciphersuites");
        System.out.println("  --dhfile, -D: DH params file");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("SSLServer", stringArray, "h:p:k:r:RcCd:fi:P:a:D:", Longopts);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 112: {
                    port = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 99: {
                    clientauth = true;
                    break;
                }
                case 67: {
                    clientauth = false;
                    renegotiate = true;
                    break;
                }
                case 107: {
                    keyfile = new String(getopt.getOptarg());
                    break;
                }
                case 114: {
                    rootfile = new String(getopt.getOptarg());
                    break;
                }
                case 80: {
                    password = new String(getopt.getOptarg());
                    break;
                }
                case 100: {
                    SSLDebug.setDebug(Integer.parseInt(getopt.getOptarg()));
                    break;
                }
                case 102: {
                    fakeseed = true;
                    break;
                }
                case 105: {
                    iterate = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 97: {
                    cipherSuites = Demo.parseCipherSuites(getopt.getOptarg());
                    break;
                }
                case 68: {
                    dhfile = new String(getopt.getOptarg());
                    break;
                }
                default: {
                    SSLServer.usage();
                    return;
                }
            }
        }
        SSLContext sSLContext = new SSLContext();
        if (fakeseed) {
            sSLContext.seedRNG(null);
        }
        try {
            sSLContext.loadRootCertificates(rootfile);
            sSLContext.loadEAYKeyFile(keyfile, password);
            if (dhfile != null) {
                sSLContext.loadDHParams(dhfile);
            }
            SSLServerSocket sSLServerSocket = new SSLServerSocket(sSLContext, port);
            SSLPolicyInt sSLPolicyInt = new SSLPolicyInt();
            if (cipherSuites != null) {
                sSLPolicyInt.setCipherSuites(cipherSuites);
            }
            sSLPolicyInt.requireClientAuth(clientauth);
            sSLContext.setPolicy(sSLPolicyInt);
            while (iterate-- != 0) {
                System.out.println("Waiting for connection on " + port);
                SSLSocket sSLSocket = (SSLSocket)sSLServerSocket.accept();
                System.out.println("Accepted connection");
                if (renegotiate) {
                    sSLPolicyInt = new SSLPolicyInt();
                    sSLPolicyInt.requireClientAuth(true);
                    sSLSocket.renegotiate(sSLPolicyInt);
                }
                if (sSLPolicyInt.requireClientAuthP()) {
                    System.out.println("Cert chain");
                    Vector vector = sSLSocket.getCertificateChain();
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        X509Cert x509Cert = (X509Cert)vector.elementAt(n2);
                        System.out.println("Issuer " + x509Cert.getIssuerName().getNameString());
                        System.out.println("Subject " + x509Cert.getSubjectName().getNameString());
                        System.out.println("Serial " + x509Cert.getSerial());
                        System.out.println("Validity " + x509Cert.getValidityNotBefore() + "-" + x509Cert.getValidityNotAfter());
                        ++n2;
                    }
                }
                SSLServer.webServe(sSLSocket);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n = 0;
        SSLServer.Longopts[n++] = new LongOpt("port", 1, null, 112);
        SSLServer.Longopts[n++] = new LongOpt("keyfile", 1, null, 107);
        SSLServer.Longopts[n++] = new LongOpt("rootfile", 1, null, 114);
        SSLServer.Longopts[n++] = new LongOpt("clientauth", 0, null, 99);
        SSLServer.Longopts[n++] = new LongOpt("password", 1, null, 80);
        SSLServer.Longopts[n++] = new LongOpt("renegotiate", 0, null, 67);
        SSLServer.Longopts[n++] = new LongOpt("debug", 1, null, 100);
        SSLServer.Longopts[n++] = new LongOpt("fakerandom", 0, null, 102);
        SSLServer.Longopts[n++] = new LongOpt("iterate", 1, null, 105);
        SSLServer.Longopts[n++] = new LongOpt("ciphersuites", 1, null, 97);
        SSLServer.Longopts[n++] = new LongOpt("dhfile", 1, null, 68);
    }
}

