/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.demo.JUtil;
import COM.claymoresystems.ptls.jxta.JXTAInputStream;
import COM.claymoresystems.ptls.jxta.JXTAOutputStream;
import COM.claymoresystems.ptls.jxta.JXTAPlainInput;
import COM.claymoresystems.ptls.jxta.JXTAPlainOutput;
import COM.claymoresystems.ptls.jxta.JXTATLSDefs;
import COM.claymoresystems.ptls.jxta.MessageImpl;
import COM.claymoresystems.ptls.jxta.MessageWireFormatBinary;
import COM.claymoresystems.ptls.jxta.TLSParams;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import jxta.security.util.URLBase64;

class JXTAServer {
    private static int port = 4433;
    private static String host = "localhost";
    private static String keyfile = "server.pem";
    private static String rootfile = "root.pem";
    private static String password = "password";
    private static LongOpt[] Longopts = new LongOpt[9];
    private static boolean clientauth = false;
    private static String cipherSuites = null;
    private static int iterate = -1;
    private static String dhfile = "dh1024.pem";
    private static String receivefileName = null;
    private static String receivefileRoot = null;
    private static final int INLEN = 72;
    private static File wf;
    private static FileOutputStream fout;

    JXTAServer() {
    }

    private static int peerFileServer(SSLSocket sSLSocket, JXTAInputStream jXTAInputStream, JXTAOutputStream jXTAOutputStream) throws IOException {
        MessageWireFormatBinary messageWireFormatBinary;
        jXTAInputStream.setPlaintextInputStream(sSLSocket);
        jXTAOutputStream.setPlaintextOutputStream(sSLSocket);
        MessageImpl messageImpl = new MessageImpl();
        MessageWireFormatBinary messageWireFormatBinary2 = messageWireFormatBinary = new MessageWireFormatBinary(JXTATLSDefs.MTYPE);
        String string = JUtil.getPlaintextProtoLine("SENDFILE:[RCV]", messageImpl, messageWireFormatBinary2, jXTAInputStream, "[RCV]");
        if (string == null) {
            return -1;
        }
        String string2 = string.substring("[RCV]".length());
        Integer n = new Integer(string2);
        int n2 = n;
        System.out.println("RECEIVING " + n2 + " bytes");
        System.out.println("SERVER SENT: [GO]");
        byte[] byArray = "[GO]\n".getBytes();
        JXTAPlainOutput.writeMessage("SENDFILE:[GO]", byArray, byArray.length, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
        int n3 = 0;
        int n4 = 32000;
        long l = System.currentTimeMillis();
        while (n3 < n2) {
            byte[] byArray2 = JXTAPlainInput.getPlaintextData("SENDFILE:DATA", messageImpl, messageWireFormatBinary2, jXTAInputStream);
            if (byArray2 == null) {
                System.out.println("TLS Close Received");
                return -1;
            }
            try {
                fout.write(byArray2, 0, byArray2.length);
            }
            catch (IOException iOException) {
                System.out.println("Write error on " + receivefileName);
                return -1;
            }
            n3 += byArray2.length;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 == 0L) {
            l3 = 1L;
        }
        long l4 = (long)(n2 + 500) / l3;
        double d = (double)l3 / 1000.0;
        System.out.println("\nRECEIVED " + n2 + " bytes in " + d + " secs (" + l4 + " Kbytes/s)");
        System.out.println("SERVER SENT [DONE]");
        byArray = "[DONE]\n".getBytes();
        JXTAPlainOutput.writeMessage("SENDFILE:[DONE]", byArray, byArray.length, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
        string = JUtil.getPlaintextProtoLine("SENDFILE:[BYE]", messageImpl, messageWireFormatBinary2, jXTAInputStream, "[BYE]");
        System.out.println("SERVER RECEIVED: " + string);
        return 0;
    }

    private static void usage() {
        System.out.println("SSLClient usage ");
        System.out.println("SSLClient [args]");
        System.out.println("  --port, -h: the port to connect to (default 4433)");
        System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
        System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
        System.out.println("  --clientauth, -c: require client authentication");
        System.out.println("  --debug, -d: set the debugging flags");
        System.out.println("  --ciphersuites, -a: allowed ciphersuites");
        System.out.println("  --dhfile, -D: DH params file");
        System.out.println("  --recvfile, -s: receive named file");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("JXTATLSServer", stringArray, "h:p:k:r:Ri:d:ufP:a:D:c:s:", Longopts);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 112: {
                    port = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 99: {
                    clientauth = true;
                    break;
                }
                case 107: {
                    keyfile = new String(getopt.getOptarg());
                    break;
                }
                case 114: {
                    rootfile = new String(getopt.getOptarg());
                    break;
                }
                case 100: {
                    SSLDebug.setDebug(Integer.parseInt(getopt.getOptarg()));
                    break;
                }
                case 97: {
                    cipherSuites = getopt.getOptarg();
                    break;
                }
                case 68: {
                    dhfile = new String(getopt.getOptarg());
                    break;
                }
                case 115: {
                    receivefileRoot = new String(getopt.getOptarg()) + ".";
                    break;
                }
                default: {
                    JXTAServer.usage();
                    return;
                }
            }
        }
        byte[] byArray = password.getBytes();
        byte[] byArray2 = URLBase64.encode((byte[])byArray);
        String string = new String(byArray2);
        System.out.println("Password = " + string);
        TLSParams tLSParams = new TLSParams();
        try {
            dhfile = null;
            tLSParams.setServerParameters(rootfile, keyfile, dhfile, string, clientauth);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        try {
            int n2 = 1;
            while (iterate-- != 0) {
                JXTAInputStream jXTAInputStream;
                block31: {
                    if (receivefileRoot != null) {
                        try {
                            receivefileName = receivefileRoot + n2;
                            ++n2;
                            wf = new File(receivefileName);
                            if (wf.exists()) {
                                wf.delete();
                                wf.createNewFile();
                            }
                            fout = new FileOutputStream(wf);
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (SecurityException securityException) {
                            System.out.println("Cannot create " + receivefileName);
                            System.exit(1);
                        }
                        catch (IOException iOException) {
                            System.out.println("Cannot create " + receivefileName);
                            System.exit(1);
                        }
                    }
                    System.out.println("\n***Waiting for connection on " + port);
                    try {
                        jXTAInputStream = new JXTAInputStream(port);
                        if (jXTAInputStream.accept() == 0) {
                            System.out.println("\nAccepted connection on port = " + port);
                            break block31;
                        }
                        throw new Error("\nAccept failed on port = " + port);
                    }
                    catch (IOException iOException) {
                        throw new Error("Accept failed on port = " + port + ", " + iOException.getMessage());
                    }
                }
                JXTAOutputStream jXTAOutputStream = new JXTAOutputStream();
                jXTAOutputStream.setNetOutputStream(jXTAInputStream.getNetOutputStream());
                System.out.println("Starting handshake");
                long l = System.currentTimeMillis();
                SSLSocket sSLSocket = new SSLSocket(tLSParams.getContext(), jXTAInputStream, jXTAOutputStream, host, port, 2);
                long l2 = System.currentTimeMillis() - l;
                if (l2 == 0L) {
                    l2 = 1L;
                }
                double d = (double)l2 / 1000.0;
                System.out.println("Handshake done[" + d + " secs]");
                if (tLSParams.getPolicy().requireClientAuthP()) {
                    System.out.println("Cert chain");
                    Vector vector = sSLSocket.getCertificateChain();
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        X509Cert x509Cert = (X509Cert)vector.elementAt(n3);
                        System.out.println("Issuer " + x509Cert.getIssuerName().getNameString());
                        System.out.println("Subject " + x509Cert.getSubjectName().getNameString());
                        System.out.println("Serial " + x509Cert.getSerial());
                        System.out.println("Validity " + x509Cert.getValidityNotBefore() + "-" + x509Cert.getValidityNotAfter());
                        ++n3;
                    }
                }
                if (receivefileName == null) {
                    System.out.println("receive file not given, writing to receiveFile");
                    receivefileName = "receiveFile";
                }
                int n4 = JXTAServer.peerFileServer(sSLSocket, jXTAInputStream, jXTAOutputStream);
                fout.close();
                if (n4 == -1) break;
                sSLSocket.close();
                try {
                    jXTAInputStream.closeNetSocket();
                }
                catch (IOException iOException) {
                    System.out.println("Connection close error on port = " + port);
                }
            }
            System.out.println("JXTAServer exiting");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n = 0;
        JXTAServer.Longopts[n++] = new LongOpt("port", 1, null, 112);
        JXTAServer.Longopts[n++] = new LongOpt("keyfile", 1, null, 107);
        JXTAServer.Longopts[n++] = new LongOpt("rootfile", 1, null, 114);
        JXTAServer.Longopts[n++] = new LongOpt("clientauth", 0, null, 99);
        JXTAServer.Longopts[n++] = new LongOpt("debug", 1, null, 100);
        JXTAServer.Longopts[n++] = new LongOpt("ciphersuites", 1, null, 97);
        JXTAServer.Longopts[n++] = new LongOpt("dhfile", 1, null, 68);
        JXTAServer.Longopts[n++] = new LongOpt("recvfile", 1, null, 115);
        wf = null;
        fout = null;
    }
}

