/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.demo.JUtil;
import COM.claymoresystems.ptls.jxta.JXTAInputStream;
import COM.claymoresystems.ptls.jxta.JXTAOutputStream;
import COM.claymoresystems.ptls.jxta.JXTAPlainOutput;
import COM.claymoresystems.ptls.jxta.JXTATLSDefs;
import COM.claymoresystems.ptls.jxta.MessageImpl;
import COM.claymoresystems.ptls.jxta.MessageWireFormatBinary;
import COM.claymoresystems.ptls.jxta.TLSParams;
import COM.claymoresystems.sslg.SSLPolicyInt;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Vector;
import jxta.security.util.URLBase64;

class JXTAClient {
    private static String host = "localhost";
    private static int port = 4433;
    private static String keyfile = "client.pem";
    private static String rootfile = "root.pem";
    private static String randomfile = "random.pem";
    private static String password = "password";
    private static LongOpt[] Longopts = new LongOpt[11];
    private static int iterate = 1;
    private static boolean acceptunverified = false;
    private static boolean checkDates = false;
    private static String cipherSuites = null;
    private static int delay = 5;
    private static String sendfileName = null;
    private static byte[] helloData = new byte[]{83, 97, 108, 117, 116, 32, 78, 105, 32, 104, 111, 119, 32, 78, 97, 121, 32, 104, 111};

    JXTAClient() {
    }

    private static void testConn(SSLContext sSLContext, String string, int n) throws IOException, UnknownHostException {
        try {
            JXTAOutputStream jXTAOutputStream;
            JXTAInputStream jXTAInputStream = new JXTAInputStream();
            try {
                jXTAOutputStream = new JXTAOutputStream(string, n);
                jXTAOutputStream.connect();
                System.out.println("\nJXTA Service@" + string + ":" + n + " contacted");
            }
            catch (IOException iOException) {
                throw new Error("\n!!!Open failed: " + string + ":" + n);
            }
            InputStream inputStream = jXTAOutputStream.getNetInputStream();
            jXTAInputStream.setNetInputStream(inputStream);
            System.out.println("Starting handshake");
            long l = System.currentTimeMillis();
            SSLSocket sSLSocket = new SSLSocket(sSLContext, jXTAInputStream, jXTAOutputStream, string, n, 1);
            long l2 = System.currentTimeMillis() - l;
            if (l2 == 0L) {
                l2 = 1L;
            }
            double d = (double)l2 / 1000.0;
            System.out.println("Handshake done[" + d + " secs]");
            jXTAInputStream.setPlaintextInputStream(sSLSocket);
            jXTAOutputStream.setPlaintextOutputStream(sSLSocket);
            Vector vector = sSLSocket.getCertificateChain();
            int n2 = sSLSocket.getCipherSuite();
            System.out.println("\n*******************************");
            System.out.println("Cipher suite: " + SSLPolicyInt.getCipherSuiteName(n2));
            if (vector != null) {
                System.out.println("Cert chain");
                int n3 = 0;
                while (n3 < vector.size()) {
                    X509Cert x509Cert = (X509Cert)vector.elementAt(n3);
                    System.out.println("Issuer " + x509Cert.getIssuerName().getNameString());
                    System.out.println("Subject " + x509Cert.getSubjectName().getNameString());
                    System.out.println("Serial " + x509Cert.getSerial());
                    System.out.println("Validity " + x509Cert.getValidityNotBefore() + "-" + x509Cert.getValidityNotAfter());
                    System.out.println("Signature Alg " + x509Cert.getSignatureAlgorithm());
                    ++n3;
                }
            }
            System.out.println("\n*******************************");
            if (sendfileName == null) {
                sendfileName = randomfile;
            } else {
                JXTAClient.sendFile(jXTAInputStream, jXTAOutputStream);
            }
            System.out.println("Closing connection");
            sSLSocket.close();
            jXTAOutputStream.closeNetSocket();
        }
        catch (SSLAlertException sSLAlertException) {
            sSLAlertException.printStackTrace();
            throw new Error(sSLAlertException.toString());
        }
    }

    private static void sendFile(JXTAInputStream jXTAInputStream, JXTAOutputStream jXTAOutputStream) throws IOException {
        int n;
        MessageWireFormatBinary messageWireFormatBinary;
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            file = new File(sendfileName);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("null file name");
            return;
        }
        long l = 0L;
        try {
            if (!file.canRead()) {
                System.out.println("Cannot read " + sendfileName);
                return;
            }
            l = file.length();
            fileInputStream = new FileInputStream(file);
        }
        catch (SecurityException securityException) {
            System.out.println("Cannot access " + sendfileName);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(sendfileName + " not found");
            return;
        }
        MessageImpl messageImpl = new MessageImpl();
        MessageWireFormatBinary messageWireFormatBinary2 = messageWireFormatBinary = new MessageWireFormatBinary(JXTATLSDefs.MTYPE);
        String string = "[RCV]" + l + "\n";
        byte[] byArray = string.getBytes();
        JXTAPlainOutput.writeMessage("SENDFILE:[RCV]", byArray, byArray.length, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
        System.out.println("CLIENT SENT: " + string);
        String string2 = "SENDFILE:[GO]";
        String string3 = JUtil.getPlaintextProtoLine(string2, messageImpl, messageWireFormatBinary2, jXTAInputStream, "[GO]");
        if (string3 == null) {
            return;
        }
        long l2 = l / 32000L;
        int n2 = (int)(l % 32000L);
        byte[] byArray2 = new byte[32000];
        System.out.println("Blocks out: " + l2 + "[" + 32000 + "] + " + n2 + " bytes");
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        int n3 = 0;
        while ((long)n3 < l2) {
            n = JXTAClient.fileBlockRead(fileInputStream, byArray2, 32000);
            if (n < 0) {
                System.out.println("File size not expected size");
                return;
            }
            JXTAPlainOutput.writeMessage("SENDFILE:DATA", byArray2, 32000, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
            l4 += 32000L;
            if (n3 % 10 == 0) {
                System.out.print("!");
            }
            ++n3;
        }
        if (n2 != 0) {
            n = JXTAClient.fileBlockRead(fileInputStream, byArray2, n2);
            if (n < 0) {
                System.out.println("File size not expected size");
                return;
            }
            JXTAPlainOutput.writeMessage("SENDFILE:DATA", byArray2, n2, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
            l4 += (long)n2;
            System.out.print("!");
        }
        System.out.println("");
        string2 = "SENDFILE:[DONE]";
        string3 = JUtil.getPlaintextProtoLine(string2, messageImpl, messageWireFormatBinary2, jXTAInputStream, "[DONE]");
        if (string3 == null) {
            return;
        }
        long l5 = System.currentTimeMillis();
        long l6 = l5 - l3;
        if (l6 == 0L) {
            l6 = 1L;
        }
        long l7 = (l + 500L) / l6;
        double d = (double)l6 / 1000.0;
        System.out.println("\nSENT " + l + " bytes in " + d + " secs (" + l7 + " Kbytes/s)");
        System.out.println("CLIENT SENT: [BYE]");
        String string4 = "[BYE]\n";
        byte[] byArray3 = string4.getBytes();
        JXTAPlainOutput.writeMessage("SENDFILE:[BYE]", byArray3, byArray3.length, 0, messageImpl, messageWireFormatBinary, jXTAOutputStream);
    }

    private static int fileBlockRead(FileInputStream fileInputStream, byte[] byArray, int n) {
        int n2;
        for (int i = 0; i < n; i += n2) {
            try {
                n2 = fileInputStream.read(byArray, i, n - i);
                if (n2 >= 0) continue;
                return -1;
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return n;
    }

    private static void usage() {
        System.out.println("JXTAClient usage ");
        System.out.println("JXTAClient [args]");
        System.out.println("  --host, -h: the host to connect to (default localhost)");
        System.out.println("  --port, -h: the port to connect to (default 4433)");
        System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
        System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
        System.out.println("  --iterate, -i: repeat the test send some number of times (default 1)");
        System.out.println("         > 1 demonstrates session caching");
        System.out.println("  --delay, -D: delay between each repeat (default 0)");
        System.out.println("  --debug, -d: set the debugging flags");
        System.out.println("  --acceptunverified, -u: accept unverifieable certificates(default true)");
        System.out.println("  --ciphersuites, -a: allowed ciphersuites");
        System.out.println("  --checkdates, -c: check dates on certificates");
        System.out.println("  --sendfile, -s: send named file");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("JXTAClient", stringArray, "h:p:k:r:Ri:d:ufP:a:D:cs:", Longopts);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    host = new String(getopt.getOptarg());
                    System.out.println("host = " + host);
                    break;
                }
                case 112: {
                    port = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 107: {
                    keyfile = new String(getopt.getOptarg());
                    break;
                }
                case 114: {
                    rootfile = new String(getopt.getOptarg());
                    break;
                }
                case 105: {
                    iterate = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 68: {
                    delay = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 117: {
                    acceptunverified = true;
                    break;
                }
                case 100: {
                    SSLDebug.setDebug(Integer.parseInt(getopt.getOptarg()));
                    break;
                }
                case 97: {
                    cipherSuites = getopt.getOptarg();
                    break;
                }
                case 99: {
                    checkDates = true;
                    break;
                }
                case 115: {
                    sendfileName = new String(getopt.getOptarg());
                    break;
                }
                default: {
                    JXTAClient.usage();
                    return;
                }
            }
        }
        System.out.println("Send file client");
        byte[] byArray = password.getBytes();
        byte[] byArray2 = URLBase64.encode((byte[])byArray);
        String string = new String(byArray2);
        System.out.println("Password = " + string);
        TLSParams tLSParams = new TLSParams();
        try {
            tLSParams.setClientParameters(rootfile, keyfile, string, cipherSuites, acceptunverified, checkDates);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        try {
            System.out.println("Starting client test:\n iterate = " + iterate + ", delay = " + delay);
            while (iterate-- > 0) {
                JXTAClient.testConn(tLSParams.getContext(), host, port);
                if (iterate <= 0 || delay <= 0) continue;
                System.out.println("Sleeping " + delay + " secs ...");
                Thread.sleep(delay * 1000);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n = 0;
        JXTAClient.Longopts[n++] = new LongOpt("host", 1, null, 104);
        JXTAClient.Longopts[n++] = new LongOpt("port", 1, null, 112);
        JXTAClient.Longopts[n++] = new LongOpt("keyfile", 1, null, 107);
        JXTAClient.Longopts[n++] = new LongOpt("rootfile", 1, null, 114);
        JXTAClient.Longopts[n++] = new LongOpt("iterate", 1, null, 105);
        JXTAClient.Longopts[n++] = new LongOpt("delay", 1, null, 68);
        JXTAClient.Longopts[n++] = new LongOpt("debug", 1, null, 100);
        JXTAClient.Longopts[n++] = new LongOpt("acceptunverified", 0, null, 117);
        JXTAClient.Longopts[n++] = new LongOpt("ciphersuites", 1, null, 97);
        JXTAClient.Longopts[n++] = new LongOpt("checkdates", 0, null, 99);
        JXTAClient.Longopts[n++] = new LongOpt("sendfile", 1, null, 115);
    }
}

