/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLuint16;
import COM.claymoresystems.ptls.SSLuint8;
import COM.claymoresystems.ptls.SSLvector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSLClientHello
extends SSLPDU {
    SSLuint16 client_version = new SSLuint16();
    SSLopaque random = new SSLopaque(32);
    SSLopaque session_id = new SSLopaque(-32);
    SSLvector cipher_suites;
    SSLvector compression_methods;

    SSLClientHello() {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        int n = 0;
        SSLDebug.debug(2, "Encoding client hello");
        n = this.client_version.encode(sSLConn, outputStream);
        n += this.random.encode(sSLConn, outputStream);
        n += this.session_id.encode(sSLConn, outputStream);
        n += this.cipher_suites.encode(sSLConn, outputStream);
        return n += this.compression_methods.encode(sSLConn, outputStream);
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n = 0;
        SSLDebug.debug(2, "Decoding client hello");
        this.cipher_suites = new SSLvector(-65535, new SSLuint16());
        this.compression_methods = new SSLvector(-255, new SSLuint8());
        n = this.client_version.decode(sSLConn, inputStream);
        n += this.random.decode(sSLConn, inputStream);
        n += this.session_id.decode(sSLConn, inputStream);
        n += this.cipher_suites.decode(sSLConn, inputStream);
        return n += this.compression_methods.decode(sSLConn, inputStream);
    }
}

