/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class RawDSASignature
extends Signature {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger XY;
    byte[] digest = null;
    SecureRandom rng;

    public RawDSASignature(String string) {
        super(string);
    }

    public RawDSASignature() {
        super("RawDSA");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Public Key");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.extractParams(dSAPublicKey.getParams());
        this.XY = dSAPublicKey.getY();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Private Key");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.extractParams(dSAPrivateKey.getParams());
        this.XY = dSAPrivateKey.getX();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a SHA-1 digest for input");
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.digest != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA may only be updated once");
        }
        if (n2 != 20) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA must have a 20 byte input");
        }
        this.digest = new byte[20];
        System.arraycopy(byArray, n, this.digest, 0, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.digest == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        if (this.rng == null) {
            this.rng = new SecureRandom();
        }
        BigInteger bigInteger = new BigInteger(180, this.rng);
        BigInteger bigInteger2 = bigInteger.mod(this.q);
        BigInteger bigInteger3 = bigInteger2.modInverse(this.q);
        BigInteger bigInteger4 = this.g.modPow(bigInteger2, this.p).mod(this.q);
        BigInteger bigInteger5 = new BigInteger(1, this.digest);
        BigInteger bigInteger6 = bigInteger5.add(this.XY.multiply(bigInteger4));
        bigInteger6 = bigInteger6.multiply(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.mod(this.q);
        byte[] byArray = bigInteger4.toByteArray();
        byte[] byArray2 = bigInteger7.toByteArray();
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 6];
        byArray3[0] = 48;
        byArray3[1] = (byte)(byArray.length + byArray2.length + 4 & 0xFF);
        int n = 2;
        byArray3[n++] = 2;
        byArray3[n++] = (byte)(byArray.length & 0xFF);
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        n += byArray.length;
        byArray3[n++] = 2;
        byArray3[n++] = (byte)(byArray2.length & 0xFF);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        return byArray3;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n = 0;
        int n2 = byArray.length;
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.digest == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        BigInteger bigInteger = new BigInteger(1, this.digest);
        this.encodeAssert(byArray, n++, 48, "Tag: expecting sequence");
        this.encodeAssert(byArray, n++, byArray.length - 2, "length");
        this.encodeAssert(byArray, n++, 2, "Tag: expecting integer");
        byte by = byArray[n++];
        if (by > (n2 -= 4)) {
            throw new SignatureException("r longer than total encoding");
        }
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n, byArray2, 0, by);
        n2 -= by;
        n += by;
        this.encodeAssert(byArray, n++, 2, "Tag: expecting integer");
        byte by2 = byArray[n++];
        if (by2 != (n2 -= 2)) {
            throw new SignatureException("incorrect length for than total encoding");
        }
        byte[] byArray3 = new byte[by2];
        System.arraycopy(byArray, n, byArray3, 0, by2);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        BigInteger bigInteger3 = new BigInteger(byArray3);
        BigInteger bigInteger4 = new BigInteger("0");
        if (bigInteger2.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger2.compareTo(this.q) >= 0) {
            return false;
        }
        if (bigInteger3.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger3.compareTo(this.q) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modInverse(this.q);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger5);
        BigInteger bigInteger7 = bigInteger6.mod(this.q);
        BigInteger bigInteger8 = bigInteger2.multiply(bigInteger5);
        BigInteger bigInteger9 = bigInteger8.mod(this.q);
        BigInteger bigInteger10 = this.g.modPow(bigInteger7, this.p);
        BigInteger bigInteger11 = this.XY.modPow(bigInteger9, this.p);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.mod(this.p);
        BigInteger bigInteger14 = bigInteger13.mod(this.q);
        return bigInteger14.equals(bigInteger2);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (string.equals("SecureRandom")) {
            this.rng = (SecureRandom)object;
            return;
        }
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    private void encodeAssert(byte[] byArray, int n, int n2, String string) throws SignatureException {
        if (byArray[n] != n2) {
            throw new SignatureException(this.getAlgorithm() + ": Encoding error. Bad " + string);
        }
    }

    private void extractParams(DSAParams dSAParams) {
        this.p = dSAParams.getP();
        this.q = dSAParams.getQ();
        this.g = dSAParams.getG();
    }
}

