/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.BitSet;

public class DERUtils {
    public static final byte BOOLEAN = 2;
    public static final byte INTEGER = 2;
    public static final byte BIT_STRING = 3;
    public static final byte OCTET_STRING = 4;
    public static final byte OID = 6;
    public static final byte SEQUENCE = 48;
    public static final byte IA5STRING = 22;

    private static void writeLength(int n, OutputStream outputStream) throws IOException {
        if (n < 128) {
            outputStream.write((byte)n);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 1;
            while (n > 0) {
                byteArrayOutputStream.write((byte)(n & 0xFF));
                n >>= 8;
                ++n2;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            outputStream.write((byte)(0x80 | byArray.length));
            n2 = 0;
            while (n2 < byArray.length) {
                outputStream.write(byArray[byArray.length - (n2 + 1)]);
                ++n2;
            }
        }
    }

    private static void encodeBytes(byte by, byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        DERUtils.writeLength(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void encodeInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0 && byArray.length > 1 && (byArray[1] & 0x80) == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        DERUtils.encodeBytes((byte)2, byArray, outputStream);
    }

    public static void encodeSequence(byte[] byArray, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)48, byArray, outputStream);
    }

    public static void encodeOID(byte[] byArray, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)6, byArray, outputStream);
    }

    public static void encodeIA5String(String string, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)22, string.getBytes(), outputStream);
    }

    public static void encodeBitString(byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(3);
        DERUtils.writeLength(byArray.length + 1, outputStream);
        outputStream.write(0);
        outputStream.write(byArray);
    }

    public static byte[] decodeSequence(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(48, inputStream);
    }

    public static byte[] decodeOID(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(6, inputStream);
    }

    public static byte[] decodeOctetString(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(4, inputStream);
    }

    public static BigInteger decodeInteger(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.readTLV(2, inputStream);
        return new BigInteger(1, byArray);
    }

    public static BitSet decodeBitStringX(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.decodeBitString(inputStream);
        byte by = byArray[0];
        BitSet bitSet = new BitSet();
        int n = 1;
        while (n < byArray.length) {
            int n2 = n == byArray.length - 1 ? 8 : 8 - by;
            int n3 = -128;
            int n4 = 0;
            while (n4 < n2) {
                if ((n3 & byArray[n]) != 0) {
                    bitSet.set((n - 1) * 8 + n4);
                }
                n3 = (byte)(n3 >> 1);
                ++n4;
            }
            ++n;
        }
        return bitSet;
    }

    public static byte[] decodeBitString(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(3, inputStream);
    }

    public static boolean decodeBoolean(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.readTLV(2, inputStream);
        if (byArray.length != 1) {
            throw new IOException("Bad encoding for boolean");
        }
        return byArray[0] != 0;
    }

    public static byte[] decodeAny(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = DERUtils.decodeTag(inputStream);
        byte[] byArray = DERUtils.readLV(inputStream);
        DERUtils.encodeBytes((byte)n, byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] readTLV(int n, InputStream inputStream) throws IOException {
        DERUtils.decodeTagOrDie(n, inputStream);
        byte[] byArray = DERUtils.readLV(inputStream);
        return byArray;
    }

    private static byte[] readLV(InputStream inputStream) throws IOException {
        int n = DERUtils.decodeLength(inputStream);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            throw new IOException("Bad encoding: short read");
        }
        return byArray;
    }

    private static void decodeTagOrDie(int n, InputStream inputStream) throws IOException {
        if (!DERUtils.decodeTag(n, inputStream)) {
            throw new IOException("Bad encoding: wrong tag");
        }
    }

    private static int decodeTag(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return n;
    }

    private static boolean decodeTag(int n, InputStream inputStream) throws IOException {
        int n2 = DERUtils.decodeTag(inputStream);
        if (n2 < 0) {
            return false;
        }
        return n2 == n;
    }

    public static boolean isTag(int n, InputStream inputStream) throws IOException {
        inputStream.mark(1);
        boolean bl = DERUtils.decodeTag(n, inputStream);
        inputStream.reset();
        return bl;
    }

    private static int decodeLength(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new IOException("Bad encoding: short read");
        }
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        int n3 = n2 & 0x7F;
        while (n3-- > 0) {
            n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Bad encoding: short read");
            }
            n *= 256;
            n += n2;
        }
        return n;
    }
}

