/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.util.sql;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Enumeration;
import org.openprivacy.sierra.util.sql.BaseStatement;
import talon.ComponentFactory;

public class Insert
extends BaseStatement {
    public void commit() throws Exception {
        String insert = this.buildSQLStatement();
        Connection connection = this.getDatabaseConnectionPool().getConnection();
        Statement statement = connection.createStatement();
        ComponentFactory.getLogger().debug((Object)insert);
        statement.executeUpdate(insert);
        connection.commit();
        this.getDatabaseConnectionPool().releaseConnection(connection);
    }

    private String buildSQLStatement() {
        StringBuffer buff = new StringBuffer();
        buff.append("INSERT INTO ");
        buff.append(this.getTable());
        Enumeration keys = this.getStrings().keys();
        buff.append(" ( ");
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buff.append(key);
            if (!keys.hasMoreElements()) continue;
            buff.append(", ");
        }
        Enumeration integerKeys = this.getIntegers().keys();
        while (integerKeys.hasMoreElements()) {
            buff.append(", ");
            String key = (String)integerKeys.nextElement();
            buff.append(key);
        }
        buff.append(" ) VALUES ( ");
        Enumeration elements = this.getStrings().elements();
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            buff.append("'");
            buff.append(element);
            buff.append("'");
            if (!elements.hasMoreElements()) continue;
            buff.append(", ");
        }
        Enumeration integerElements = this.getIntegers().elements();
        while (integerElements.hasMoreElements()) {
            buff.append(", ");
            Integer value = (Integer)integerElements.nextElement();
            buff.append(value);
        }
        buff.append(" );");
        return buff.toString();
    }
}

