/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.util.JxtaTimer;
import net.jxta.impl.util.JxtaTimerHandler;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class SimpleRdvMonitor
implements RendezVousMonitor,
JxtaTimerHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$util$SimpleRdvMonitor == null ? (class$net$jxta$util$SimpleRdvMonitor = SimpleRdvMonitor.class$("net.jxta.util.SimpleRdvMonitor")) : class$net$jxta$util$SimpleRdvMonitor).getName());
    private static final long LeaseRenewalDelay = 900000L;
    private PeerGroup group = null;
    private String gId = null;
    private DiscoveryService discovery = null;
    private long lease = 0L;
    private JxtaTimer timer = null;
    private Vector rdvs = null;
    private RendezVousService rendezvous = null;
    static /* synthetic */ Class class$net$jxta$util$SimpleRdvMonitor;

    public SimpleRdvMonitor(PeerGroup g, RendezVousService rendezvous) {
        this.group = g;
        this.gId = g.getPeerGroupID().toString();
        this.rdvs = new Vector();
        this.timer = null;
        this.rendezvous = rendezvous;
        this.discovery = this.group.getDiscoveryService();
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 900000L);
        }
    }

    public void connected(PeerID peer, long lease) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connected: new connection to a RendezVousService");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   peer = " + peer.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  lease = " + lease));
            }
        }
        this.addRendezVous(peer.toString(), lease);
        this.publishAdv(peer, lease);
    }

    public void disconnected(PeerID peer) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"lostConnection with RendezVousService");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("     peerId = " + peer.toString()));
            }
        }
    }

    public void discovered(Advertisement adv) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"discovered: got new RendezVousService advertisement.");
        }
        if (this.discovery != null) {
            try {
                this.discovery.publish(adv, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void signal(JxtaTimer timer) {
        if (this.rdvs == null) {
            return;
        }
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 900000L);
        }
        RdV rdv = null;
        int i = 0;
        while (i < this.rdvs.size()) {
            try {
                rdv = (RdV)this.rdvs.elementAt(i);
                this.rendezvous.connectToRendezVous(this.group.getEndpointService().newEndpointAddress(rdv.peer));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    private synchronized void addRendezVous(String peer, long lease) {
        RdV rdv = new RdV(peer);
        if (this.rdvs.contains(rdv)) {
            try {
                int index = this.rdvs.indexOf(rdv);
                if (index == -1) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"addRendezVous cannot access RdV object");
                    }
                    return;
                }
                rdv = (RdV)this.rdvs.elementAt(index);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("addRendez failed [1] " + e));
                }
            }
        } else {
            this.rdvs.addElement(rdv);
        }
        long time = System.currentTimeMillis();
        if (time + lease < 0L) {
            lease = 3600000L;
        }
        rdv.lease = time + lease;
        if (this.timer == null) {
            this.timer = new JxtaTimer(this, 900000L, true);
        }
    }

    private RdvAdvertisement createRdvAdv(PeerGroupID gid, PeerID rdvid, long timeout) {
        RdvAdvertisement adv = null;
        try {
            adv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
        }
        catch (Exception all) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Advertisement document could not be created");
            }
            return null;
        }
        adv.setGroupID(gid);
        adv.setPeerID(rdvid);
        return adv;
    }

    protected void startRdv() {
        this.publishAdv(this.group.getPeerID(), 900000L);
    }

    private void publishAdv(PeerID pid, long lease) {
        block10: {
            RdvAdvertisement rdv;
            if (LOG.isDebugEnabled()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Publish RdvAdvertisement:");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("        gid = " + this.group.getPeerGroupID().toString()));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("        pid = " + pid.toString()));
                }
            }
            if ((rdv = this.createRdvAdv(this.group.getPeerGroupID(), pid, lease)) == null) {
                return;
            }
            RefPeerGroup parent = ((GenericPeerGroup)this.group).getParentGroup();
            if (parent == null) {
                return;
            }
            DiscoveryService parentDiscovery = parent.getDiscoveryService();
            if (parentDiscovery == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cannot access parent's DiscoveryService Service");
                }
                return;
            }
            try {
                parentDiscovery.publish(rdv, 2, 1471228928L, lease);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                LOG.warn((Object)"Cannot locally publish advertisement");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RdV {
        protected String peer;
        protected long lease;

        public RdV(String peer) {
            this.peer = peer;
            this.lease = 0L;
        }

        public boolean equals(Object obj) {
            RdV rdv = (RdV)obj;
            return rdv.peer.equals(this.peer);
        }
    }
}

