/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class ClassFactory {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$util$ClassFactory == null ? (class$net$jxta$util$ClassFactory = ClassFactory.class$("net.jxta.util.ClassFactory")) : class$net$jxta$util$ClassFactory).getName());
    static /* synthetic */ Class class$net$jxta$util$ClassFactory;

    protected ClassFactory() {
    }

    protected abstract Hashtable getAssocTable();

    protected abstract Class getClassForKey();

    protected Enumeration getAvailableKeys() {
        return this.getAssocTable().keys();
    }

    protected abstract Class getClassOfInstantiators();

    protected boolean registerFromResources(String resourceName, String propertyName) throws MissingResourceException {
        ResourceBundle jxtaRsrcs = ResourceBundle.getBundle(resourceName);
        String fromProps = jxtaRsrcs.getString(propertyName).trim();
        return this.registerFromString(fromProps);
    }

    protected boolean registerFromString(String classNamesString) {
        boolean registeredSomething = false;
        if (null == classNamesString || 0 == classNamesString.length()) {
            return false;
        }
        StringTokenizer eachInstanceClass = new StringTokenizer(classNamesString);
        while (eachInstanceClass.hasMoreTokens()) {
            String willInitialize = eachInstanceClass.nextToken();
            try {
                registeredSomething |= this.registerAssoc(willInitialize);
            }
            catch (Exception allElse) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)("Failed to register '" + willInitialize + "'"), (Throwable)allElse);
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(String className) throws Exception {
        boolean registeredSomething;
        block4: {
            registeredSomething = false;
            try {
                Class<?> ignored = Class.forName(className);
                registeredSomething = true;
            }
            catch (ClassNotFoundException ignored) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Failed to locate '" + className + "'"));
                }
            }
            catch (NoClassDefFoundError ignored) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)("Failed to locate '" + className + "'"));
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(Object key, Object instantiator) {
        Class<?> itsA;
        if (!this.getClassOfInstantiators().isInstance(instantiator)) {
            throw new ClassCastException("instantiator '" + instantiator.getClass().getName() + "' does not implement '" + this.getClassOfInstantiators().getName() + "'");
        }
        Class requiredKeyClass = this.getClassForKey();
        if (!requiredKeyClass.isAssignableFrom(itsA = key.getClass())) {
            throw new IllegalArgumentException("Incorrect Class for key type");
        }
        if (null != this.getAssocTable().get(key)) {
            return false;
        }
        this.getAssocTable().put(key, instantiator);
        return true;
    }

    protected Object getInstantiator(Object key) throws NoSuchElementException {
        Class requiredKeyClass = this.getClassForKey();
        if (!requiredKeyClass.isAssignableFrom(key.getClass())) {
            throw new IllegalArgumentException("Incorrect Class for key type");
        }
        Object instantiator = this.getAssocTable().get(key);
        if (null == instantiator) {
            throw new NoSuchElementException("key '" + key + "' not registered.");
        }
        return instantiator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

