/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Application;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.test.util.Util;

public class BidirectionalAcceptPipeTestApp
implements Application {
    BidirectionalPipeService bps;

    public void init(PeerGroup peerGroup, ID id, Advertisement adv) {
        this.bps = new BidirectionalPipeService(peerGroup);
    }

    public int startApp(String[] argv) {
        String pipeName = argv == null || argv.length == 0 ? "TestPipe" : argv[0];
        try {
            BidirectionalPipeService.AcceptPipe acceptPipe = this.bps.bind(pipeName);
            PipeAdvertisement adv = acceptPipe.getAdvertisement();
            Util.save(adv, new File(pipeName + ".xml"));
            while (true) {
                try {
                    BidirectionalPipeService.Pipe pipe = acceptPipe.accept(30000);
                    System.out.println("BPS: Accepted pipe " + pipe);
                    Message msg = pipe.getInputPipe().poll(30000);
                    InputStream in2 = msg.getElement("Test").getStream();
                    byte[] buf = new byte[8192];
                    int r = in2.read(buf);
                    System.out.println("Client said: " + new String(buf, 0, r));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void stopApp() {
    }
}

