/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jxta.impl.index.IndexServiceImpl;
import net.jxta.index.IndexService;

public class IndexServiceTest {
    public static void main(String[] argv) throws IOException, IndexService.BadDocumentException, IndexService.BadQueryException, IndexService.IndexException, InterruptedException {
        IndexServiceImpl indexService = new IndexServiceImpl();
        IndexService.Index index = indexService.getIndex(new File(argv[0]));
        int i = 0;
        while (i < 10) {
            IndexServiceTest.test(indexService, index, argv, 1, argv.length - 2, argv[argv.length - 1]);
            ++i;
        }
        Thread.currentThread();
        Thread.sleep(3600000L);
    }

    static void test(IndexService indexService, IndexService.Index index, String[] files, int filesStart, int filesCount, String query) throws IOException, IndexService.BadDocumentException, IndexService.BadQueryException, IndexService.IndexException {
        int i = filesStart;
        while (i < filesStart + filesCount) {
            System.out.println("\nIndexing " + files[i]);
            IndexServiceTest.addFile(index, files[i]);
            System.out.println("Stats:");
            ((IndexServiceImpl)indexService).printStats();
            ++i;
        }
        String[] resultSet = index.query(query);
        System.out.println("Result set: " + resultSet.length + " items:");
        int j = 0;
        while (resultSet != null && j < resultSet.length) {
            System.out.println("\t" + j + " " + resultSet[j]);
            ++j;
        }
        int i2 = filesStart;
        while (i2 < filesStart + filesCount) {
            System.out.println("Removing " + files[i2]);
            IndexServiceTest.removeFile(index, files[i2]);
            resultSet = index.query(query);
            System.out.println("Result set: " + resultSet.length + " items:");
            int j2 = 0;
            while (resultSet != null && j2 < resultSet.length) {
                System.out.println("\t" + j2 + " " + resultSet[j2]);
                ++j2;
            }
            ++i2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeFile(IndexService.Index index, String file) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        File f = new File(file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            index.remove(file, in);
            Object var5_4 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addFile(IndexService.Index index, String file) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        File f = new File(file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            index.add(file, in);
            System.out.println("Finalizing...");
            Runtime.getRuntime().runFinalization();
            System.out.println("Garbage-collecting...");
            Runtime.getRuntime().gc();
            Object var5_4 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException e) {}
    }
}

