/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.cm;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExpirationList {
    Hashtable table = new Hashtable();
    static final int SCHEDULE = 1;
    static final int CANCEL = 2;

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.out.println("Usage: java net.jxta.test.cm.ExpirationList db_file");
        } else {
            File db = new File(argv[0]);
            ExpirationList test = new ExpirationList();
            test.readList(db);
            test.printList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readList(File f) throws IOException {
        DataInputStream in = null;
        try {
            try {
                in = new DataInputStream(new FileInputStream(f));
                this.readList(in);
            }
            catch (EOFException e) {
                Object var5_4 = null;
                if (in == null) return;
                in.close();
                return;
            }
            Object var5_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    void readList(DataInputStream in) throws IOException {
        boolean i = false;
        while (true) {
            int action = in.readInt();
            File file = new File(in.readUTF());
            long timeInMyCache = in.readLong();
            long timeoutForOthers = in.readLong();
            if (!file.exists()) continue;
            switch (action) {
                case 1: {
                    if (timeInMyCache <= System.currentTimeMillis()) break;
                    this.table.put(file, new Entry(file, timeInMyCache, timeoutForOthers));
                    break;
                }
                case 2: {
                    this.table.remove(file);
                }
            }
        }
    }

    public void printList() {
        Enumeration elements = this.table.elements();
        while (elements.hasMoreElements()) {
            Entry entry = (Entry)elements.nextElement();
            System.out.println(entry);
        }
    }

    class Entry {
        File file;
        long timeInMyCache;
        long timeForOthers;

        Entry(File file, long timeInMyCache, long timeForOthers) {
            this.file = file;
            this.timeInMyCache = timeInMyCache;
            this.timeForOthers = timeForOthers;
        }

        public String toString() {
            return "" + this.file + " " + this.timeInMyCache + " " + this.timeForOthers;
        }
    }
}

