/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.IOException;
import java.io.InputStream;

public class XmlParser {
    static final int NO_TAG = 0;
    static final int PARSING_TAG = 1;
    static final int EAT_TAG = 2;
    static final int EAT_TOKEN = 3;
    static final int NONE = 0;
    static final int NAME = 1;
    static final int VALUE_START_QUOTE = 2;
    static final int VALUE = 3;
    static final int VALUE_END_QUOTE = 4;
    static final byte[] space = new byte[]{32};

    static void callStartTag(byte[] tag, int start, int len, ParserCallback cb) throws Exception {
        int i = start + 1;
        int end = start + len;
        while (i < end) {
            if (Character.isWhitespace((char)tag[i]) || tag[i] == 62) break;
            ++i;
        }
        cb.startTag(tag, start + 1, i - start - 1);
    }

    public static String getTagName(byte[] tag, int start, int len) {
        int i = start + 1;
        int end = start + len;
        while (i < end) {
            if (Character.isWhitespace((char)tag[i]) || tag[i] == 62) break;
            ++i;
        }
        return new String(tag, start + 1, i - start - 1);
    }

    public static String getAttributeValue(byte[] attributeName, byte[] tag, int start, int len) {
        int valStart = XmlParser.indexOf(attributeName, tag, start, len);
        int valLen = 0;
        if (valStart == -1) {
            return null;
        }
        if (tag[valStart += attributeName.length + 2] == 34 || tag[valStart] == 39) {
            ++valStart;
        }
        int i = valStart;
        while (i < start + len) {
            if (tag[i] == 39 || tag[i] == 34 || tag[i] == 62 || Character.isWhitespace((char)tag[i])) {
                valLen = i - valStart;
                break;
            }
            ++i;
        }
        return new String(tag, valStart, valLen);
    }

    public static int getIntAttribute(byte[] attributeName, byte[] tag, int start, int len, int defaultValue) {
        int valStart = XmlParser.indexOf(attributeName, tag, start, len);
        boolean valLen = false;
        int val = 0;
        if (valStart == -1) {
            return defaultValue;
        }
        if (tag[valStart += attributeName.length + 2] == 34 || tag[valStart] == 39) {
            ++valStart;
        }
        int i = valStart;
        while (i < start + len) {
            if (tag[i] == 39 || tag[i] == 34 || tag[i] == 62 || Character.isWhitespace((char)tag[i])) break;
            if (tag[i] > 57 || tag[i] < 48) {
                return defaultValue;
            }
            val = val * 10 + (tag[i] - 48);
            ++i;
        }
        return val;
    }

    /*
     * WARNING - void declaration
     */
    public static long parse(InputStream reader, byte[] chars, ParserCallback callback) throws IOException, Exception {
        int r;
        int state = 0;
        boolean closeTag = false;
        boolean potentialCloseTag = false;
        int startChars = 0;
        int startTag = 0;
        int startRead = 0;
        int endToken = 0;
        int previousChar = -1;
        boolean inAttribute = false;
        boolean potentialEntityReference = false;
        long total = 0L;
        while ((r = reader.read(chars, startRead, chars.length - startRead)) > 0) {
            void var8_14;
            int endRead = startRead + var8_14;
            total += (long)var8_14;
            int i = startRead;
            while (i < endRead) {
                block0 : switch (state) {
                    case 3: {
                        switch (chars[i]) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                endToken = i;
                                state = 0;
                                break;
                            }
                            case 60: {
                                state = 1;
                                startTag = i;
                                closeTag = false;
                                potentialCloseTag = false;
                            }
                        }
                        startChars = i + 1;
                        break;
                    }
                    case 0: {
                        switch (chars[i]) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                if (!potentialEntityReference) break;
                                throw new Exception("Bare & found.");
                            }
                            case 60: {
                                if (potentialEntityReference) {
                                    throw new Exception("Bare & found.");
                                }
                                if (startChars != i) {
                                    callback.chars(chars, startChars, i - startChars);
                                }
                                state = 1;
                                startTag = i;
                                closeTag = false;
                                break;
                            }
                            case 38: {
                                if (potentialEntityReference) {
                                    throw new Exception("Unescaped & found.");
                                }
                                potentialEntityReference = true;
                                break;
                            }
                            case 59: {
                                if (!potentialEntityReference) break;
                                potentialEntityReference = false;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (chars[i]) {
                            case 32: {
                                if (previousChar == 60) {
                                    throw new Exception("Unescaped < in char data.");
                                }
                                if (!inAttribute || !potentialEntityReference) break block0;
                                throw new Exception("Bare & found in attribute value.");
                            }
                            case 34: 
                            case 39: {
                                if (!inAttribute && previousChar == 61) {
                                    inAttribute = true;
                                    break block0;
                                }
                                if (!inAttribute) break block0;
                                if (potentialEntityReference) {
                                    throw new Exception("Invalid use of & in attribute value.");
                                }
                                inAttribute = false;
                                break block0;
                            }
                            case 60: {
                                if (inAttribute) {
                                    throw new Exception("Unescaped " + (char)chars[i] + " character found in " + " attribute value.");
                                }
                            }
                            case 47: {
                                if (i == startTag + 1) {
                                    closeTag = true;
                                    break block0;
                                }
                                potentialCloseTag = true;
                                break block0;
                            }
                            case 62: {
                                if (inAttribute) {
                                    throw new Exception("Attribute value must be terminated by a ' or \".");
                                }
                                if (potentialCloseTag || !closeTag) {
                                    XmlParser.callStartTag(chars, startTag, i - startTag + 1, callback);
                                    XmlParser.iterateAttributes(chars, startTag, i - startTag + 1, callback);
                                }
                                if (potentialCloseTag) {
                                    callback.endTag(chars, startTag + 1, i - startTag - 3);
                                } else if (closeTag) {
                                    callback.endTag(chars, startTag + 2, i - startTag - 2);
                                }
                                state = 0;
                                startChars = i + 1;
                                endToken = i + 1;
                                break block0;
                            }
                            case 38: {
                                if (!inAttribute) break block0;
                                if (potentialEntityReference) {
                                    throw new Exception("Invalid & usage.");
                                }
                                potentialEntityReference = true;
                                break block0;
                            }
                            case 59: {
                                if (!potentialEntityReference) break block0;
                                potentialEntityReference = false;
                                break block0;
                            }
                        }
                        if (previousChar == 61) {
                            throw new Exception("Attribute values must be quoted and the quotes must immediately follow the = sign.");
                        }
                        if (!potentialCloseTag) break;
                        potentialCloseTag = false;
                        break;
                    }
                    case 2: {
                        if (chars[i] != 62) break;
                        state = 0;
                        startChars = i + 1;
                        endToken = i + 1;
                    }
                }
                previousChar = chars[i];
                ++i;
            }
            switch (state) {
                case 0: {
                    if (startChars < endRead) {
                        if (endToken - startChars > 0) {
                            callback.chars(chars, startChars, endToken - startChars);
                        }
                        if (endRead - endToken < chars.length) {
                            System.arraycopy(chars, endToken, chars, 0, endRead - endToken);
                            startRead = endRead - endToken;
                        } else {
                            state = 3;
                            startRead = 0;
                        }
                    }
                    startChars = 0;
                    endToken = 0;
                    startChars = 0;
                    break;
                }
                case 1: {
                    if (startTag > endRead / 2) {
                        System.arraycopy(chars, startTag, chars, 0, endRead - startTag);
                        startRead = endRead - startTag;
                        startTag = 0;
                        break;
                    }
                    state = 2;
                    startTag = 0;
                    startRead = 0;
                }
            }
        }
        return total;
    }

    static void iterateAttributes(byte[] tag, int start, int len, ParserCallback cb) throws Exception {
        int end = start + len;
        int state = 0;
        int nameStart = 0;
        int nameLength = 0;
        int valueStart = 0;
        while (start < end) {
            if (Character.isWhitespace((char)tag[start]) || tag[start] == 62) break;
            ++start;
        }
        int i = start;
        while (i < end) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)tag[i])) break;
                    state = 1;
                    nameStart = i;
                    break;
                }
                case 1: {
                    if (tag[i] != 61) break;
                    nameLength = i - nameStart;
                    state = 2;
                    break;
                }
                case 2: {
                    if (tag[i] != 39 && tag[i] != 34) {
                        throw new Exception("Invalid attribute value encoding.");
                    }
                    state = 3;
                    valueStart = i;
                    break;
                }
                case 3: {
                    if (!Character.isWhitespace((char)tag[i]) && tag[i] != 39 && tag[i] != 34 && tag[i] != 62) break;
                    cb.attribute(tag, nameStart, nameLength, tag, valueStart + 1, i - valueStart - 1);
                    state = 4;
                    break;
                }
                case 4: {
                    state = 0;
                }
            }
            ++i;
        }
    }

    public static boolean startsWith(byte[] what, byte[] chars, int start, int len) {
        if (what.length <= len) {
            int i = 0;
            while (i < what.length) {
                if (Character.toUpperCase((char)chars[i + start]) != what[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] argv) throws IOException, Exception {
        XmlParser parser = new XmlParser();
        ParserCallback callback = new ParserCallback(){

            public void startTag(byte[] chars, int start, int len) {
                System.out.println("Start: " + new String(chars, start, len));
            }

            public void attribute(byte[] nameChars, int nameStart, int nameLength, byte[] valueChars, int valueStart, int valueLength) {
            }

            public void chars(byte[] chars, int start, int len) {
                System.out.println("Chars: ." + new String(chars, start, len) + ".");
            }

            public void endTag(byte[] chars, int start, int len) {
                System.out.println("End: " + new String(chars, start, len));
            }
        };
        byte[] buf = new byte[64];
        InputStream reader = System.in;
        XmlParser.parse(reader, buf, callback);
    }

    private static int indexOf(byte[] what, byte[] chars, int start, int len) {
        int i = start;
        while (i < start + len) {
            int j = 0;
            while (j < what.length) {
                if (Character.toUpperCase((char)chars[i + j]) != what[j]) break;
                ++j;
            }
            if (j == what.length) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static interface ParserCallback {
        public void startTag(byte[] var1, int var2, int var3) throws Exception;

        public void attribute(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws Exception;

        public void chars(byte[] var1, int var2, int var3) throws Exception;

        public void endTag(byte[] var1, int var2, int var3) throws Exception;
    }

    public static class Exception
    extends java.lang.Exception {
        java.lang.Exception nested;

        public Exception(String msg) {
            super(msg);
        }

        public Exception(String msg, java.lang.Exception nested) {
            super(msg);
            this.nested = nested;
        }

        public java.lang.Exception getNestedException() {
            return this.nested;
        }
    }
}

