/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.jxta.impl.xml.XmlParser;

public class BinaryXmlGenerator {
    static final int INTERN = 1;
    static final int START_TAG = 2;
    static final int ATTRIBUTE_NAME = 3;
    static final int ATTRIBUTE_VALUE = 4;
    static final int CHARS = 5;
    static final int END_TAG = 6;
    static final int END_DOCUMENT = 7;
    XmlParser parser = new XmlParser();

    public void generate(InputStream in, OutputStream out, AtomTable atomTable, byte[] buf) throws IOException, XmlParser.Exception {
        XmlParser.parse(in, buf, new ParserCallback(atomTable, out));
        out.write(7);
    }

    int emitInstruction(DataOutputStream out, AtomTable atomTable, int instruction, byte[] value, int valueStart, int valueLen) throws IOException {
        String atom = new String(value, valueStart, valueLen);
        int id = atomTable.getId(atom);
        if (id == -1) {
            id = atomTable.intern(atom);
            out.write(1);
            out.writeInt(id);
            out.writeInt(valueLen);
            out.write(value, valueStart, valueLen);
        }
        out.write(instruction);
        out.writeInt(id);
        return id;
    }

    class ParserCallback
    implements XmlParser.ParserCallback {
        AtomTable atomTable;
        DataOutputStream out;
        int curTagId;

        ParserCallback(AtomTable atomTable, OutputStream out) {
            this.atomTable = atomTable;
            this.out = new DataOutputStream(out);
        }

        public void startTag(byte[] chars, int start, int len) throws XmlParser.Exception {
            try {
                this.curTagId = BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 2, chars, start, len);
            }
            catch (IOException e) {
                throw new XmlParser.Exception("IOException writing binary data.", e);
            }
        }

        public void attribute(byte[] nameChars, int nameStart, int nameLen, byte[] valueChars, int valueStart, int valueLen) throws XmlParser.Exception {
            try {
                BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 3, nameChars, nameStart, nameLen);
                BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 4, valueChars, valueStart, valueLen);
            }
            catch (IOException e) {
                throw new XmlParser.Exception("IOException writing binary data.", e);
            }
        }

        public void chars(byte[] chars, int start, int len) throws XmlParser.Exception {
            int i = start;
            while (i < start + len) {
                if (!Character.isWhitespace((char)chars[i])) break;
                ++i;
            }
            int newStart = i;
            i = start + len;
            while (i >= newStart) {
                if (!Character.isWhitespace((char)chars[i])) break;
                --i;
            }
            int newLen = i - newStart;
            try {
                this.out.write(5);
                this.out.writeInt(newLen);
                this.out.write(chars, newStart, newLen);
            }
            catch (IOException e) {
                throw new XmlParser.Exception("IOException writing binary data.", e);
            }
        }

        public void endTag(byte[] chars, int start, int len) throws XmlParser.Exception {
            try {
                this.out.write(6);
                this.out.writeInt(this.curTagId);
            }
            catch (IOException e) {
                throw new XmlParser.Exception("IOException writing binary data.", e);
            }
        }
    }

    public static class AtomTable {
        HashMap table = new HashMap();
        int nextId = 0;
        int maxAtoms;
        int maxSize;
        int size;

        public AtomTable(int maxAtoms, int maxSize) {
            this.maxAtoms = maxAtoms;
            this.maxSize = maxSize;
        }

        int getId(String atom) {
            Integer id = (Integer)this.table.get(atom);
            return id == null ? -1 : id;
        }

        int intern(String atom) {
            if (this.nextId == this.maxAtoms) {
                this.nextId = 0;
            }
            if ((this.size += atom.length()) > this.maxSize) {
                this.nextId = 0;
            }
            int id = this.nextId++;
            this.table.put(atom, new Integer(id));
            return id;
        }
    }
}

