/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;
import net.jxta.impl.util.PriorityQueue;

class IncomingMessageQueue
extends PriorityQueue {
    int capacity;
    int total;
    long nextExpected;

    IncomingMessageQueue(int size) {
        this.initialize(size, 2);
        this.capacity = size;
    }

    protected boolean lessThan(Object o1, Object o2) {
        return ((IncomingMessage)o1).seq < ((IncomingMessage)o2).seq;
    }

    public synchronized void put(Message msg, long seq) {
        this.put(new IncomingMessage(msg, seq));
        ++this.total;
        this.notifyAll();
    }

    public synchronized long popUntilBreakInSequence(long lastSeq) {
        while (this.top() != null) {
            IncomingMessage msg = (IncomingMessage)this.top();
            if (lastSeq + 1L != msg.seq) break;
            lastSeq = msg.seq;
            this.pop();
        }
        return lastSeq;
    }

    public synchronized Message pop(long maxTimeout) throws InterruptedException {
        IncomingMessage im;
        long start = System.currentTimeMillis();
        while (true) {
            if (this.top() != null) {
                long timeout = maxTimeout - (System.currentTimeMillis() - start);
                if (timeout > 0L) {
                    this.wait(timeout);
                    continue;
                }
            }
            if ((im = (IncomingMessage)this.top()) == null) {
                return null;
            }
            if (im.seq == this.nextExpected) break;
        }
        this.pop();
        --this.total;
        this.nextExpected = im.seq + 1L;
        return im.msg;
    }

    public int getFreeSlots() {
        return this.capacity - this.total;
    }

    class IncomingMessage {
        Message msg;
        long seq;

        IncomingMessage(Message msg, long seq) {
            this.msg = msg;
            this.seq = seq;
        }
    }
}

