/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

public class BidirectionalPipeService {
    PeerGroup peerGroup;
    DiscoveryService discoveryService;
    PipeService pipeService;

    public BidirectionalPipeService(PeerGroup peerGroup) {
        this.peerGroup = peerGroup;
        this.pipeService = peerGroup.getPipeService();
        this.discoveryService = peerGroup.getDiscoveryService();
    }

    public AcceptPipe bind(String pipeName) throws IOException {
        PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        inputPipeAdv.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        inputPipeAdv.setName(pipeName + ".end1");
        InputPipe inputPipe = this.pipeService.createInputPipe(inputPipeAdv);
        this.discoveryService.publish(inputPipeAdv, 2);
        this.discoveryService.remotePublish(inputPipeAdv, 2);
        System.out.println("Published bidir pipe " + inputPipeAdv.getPipeID());
        return new AcceptPipe(inputPipeAdv, inputPipe);
    }

    public Pipe connect(PipeAdvertisement adv, int timeout) throws IOException {
        InputStream in;
        Document inputPipeAdvDoc;
        OutputPipe connectToPipe = this.pipeService.createOutputPipe(adv, timeout / 2);
        PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        inputPipeAdv.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        inputPipeAdv.setName(adv.getName() + ".in");
        InputPipe inputPipe = this.pipeService.createInputPipe(inputPipeAdv);
        Message msg = this.pipeService.createMessage();
        try {
            inputPipeAdvDoc = inputPipeAdv.getDocument(new MimeMediaType("text/xml"));
        }
        catch (Exception e) {
            throw new IOException("Unable to create input pipe advertisement document.");
        }
        msg.addElement(msg.newMessageElement("InputPipeAdv", null, inputPipeAdvDoc.getStream()));
        connectToPipe.send(msg);
        try {
            msg = inputPipe.poll(timeout / 2);
            if (msg == null || (in = msg.getElement("InputPipeAdvAck").getStream()) == null) {
                throw new IOException("Expecting bi-directional pipe confirmation.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Did not receive expected bi-directional confirmation.");
        }
        PipeAdvertisement outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text", "xml"), in);
        OutputPipe outputPipe = this.pipeService.createOutputPipe(outputPipeAdv, timeout / 2);
        return new Pipe(inputPipe, outputPipe);
    }

    class PipeMsgListenerImpl
    implements PipeMsgListener {
        MessageListener msgListener;
        OutputPipe outputPipe;

        PipeMsgListenerImpl(MessageListener msgListener, OutputPipe outputPipe) {
            this.msgListener = msgListener;
            this.outputPipe = outputPipe;
        }

        public void pipeMsgEvent(PipeMsgEvent ev) {
            this.msgListener.messageReceived(ev.getMessage(), this.outputPipe);
        }
    }

    public static interface MessageListener {
        public void messageReceived(Message var1, OutputPipe var2);
    }

    public class Pipe {
        InputPipe inputPipe;
        OutputPipe outputPipe;
        MessageListener msgListener;

        Pipe(InputPipe inputPipe, OutputPipe outputPipe) {
            this.inputPipe = inputPipe;
            this.outputPipe = outputPipe;
        }

        public InputPipe getInputPipe() {
            return this.inputPipe;
        }

        public OutputPipe getOutputPipe() {
            return this.outputPipe;
        }
    }

    public class AcceptPipe {
        PipeAdvertisement acceptInputPipeAdv;
        InputPipe acceptInputPipe;
        boolean done;

        AcceptPipe(PipeAdvertisement acceptInputPipeAdv, InputPipe acceptInputPipe) {
            this.acceptInputPipeAdv = acceptInputPipeAdv;
            this.acceptInputPipe = acceptInputPipe;
            this.done = false;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptInputPipeAdv;
        }

        public Pipe accept(int timeout) throws IOException, InterruptedException {
            return this.accept(timeout, null);
        }

        public Pipe accept(int timeout, MessageListener ml) throws IOException, InterruptedException {
            Message msg = this.acceptInputPipe.poll(timeout / 2);
            if (msg == null) {
                throw new InterruptedException("Timed out in accept.");
            }
            if (this.done && msg.hasElement("Close")) {
                throw new InterruptedException();
            }
            if (!this.done) {
                Document inputPipeAdvDoc;
                InputStream in = msg.getElement("InputPipeAdv").getStream();
                PipeAdvertisement outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text", "xml"), in);
                OutputPipe outputPipe = BidirectionalPipeService.this.pipeService.createOutputPipe(outputPipeAdv, timeout / 2);
                PipeAdvertisement inputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
                inputPipeAdv.setPipeID(IDFactory.newPipeID(BidirectionalPipeService.this.peerGroup.getPeerGroupID()));
                inputPipeAdv.setName(outputPipeAdv.getName() + ".out");
                InputPipe inputPipe = ml == null ? BidirectionalPipeService.this.pipeService.createInputPipe(inputPipeAdv) : BidirectionalPipeService.this.pipeService.createInputPipe(inputPipeAdv, new PipeMsgListenerImpl(ml, outputPipe));
                try {
                    inputPipeAdvDoc = inputPipeAdv.getDocument(new MimeMediaType("text/xml"));
                }
                catch (Exception e) {
                    throw new IOException("Unable to create input pipe advertisement document.");
                }
                msg = BidirectionalPipeService.this.pipeService.createMessage();
                msg.addElement(msg.newMessageElement("InputPipeAdvAck", null, inputPipeAdvDoc.getStream()));
                System.out.println("Sending bidir pipe ack.");
                outputPipe.send(msg);
                return new Pipe(inputPipe, outputPipe);
            }
            throw new IOException("Pipe closed.");
        }

        public synchronized void close() {
            this.done = true;
            this.acceptInputPipe.close();
        }
    }
}

