/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RendAddrCompactor
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendAddrCompactor == null ? (class$net$jxta$impl$rendezvous$RendAddrCompactor = RendAddrCompactor.class$("net.jxta.impl.rendezvous.RendAddrCompactor")) : class$net$jxta$impl$rendezvous$RendAddrCompactor).getName());
    private PeerGroup myGroup;
    private EndpointService endpoint;
    private DiscoveryService discovery;
    private RendezVousService rendezvous = null;
    private String localPeerId = null;
    private Vector initialParams = null;
    private Thread myThread = null;
    protected boolean stopping = false;
    private RdvListener rdvListener = null;
    private static final int MaxNbOfRdvs = 3;
    private static final long DiscoveryLongNap = 2400000L;
    private static final long DiscoveryMediumNap = 1200000L;
    private static final long DiscoveryShortNap = 600000L;
    private static final int MaxNbOfConnectThreads = 5;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendAddrCompactor;

    private EndpointAddress mkAddress(String destPeer) {
        try {
            PeerID asID = (PeerID)IDFactory.fromURL(new URL(destPeer));
            String asString = "jxta://" + asID.getUniqueValue().toString();
            EndpointAddress addr = this.endpoint.newEndpointAddress(asString);
            return addr;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + destPeer));
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        EndpointAddress addr = this.mkAddress(destPeer);
        addr.setServiceName(serv);
        addr.setServiceParameter(parm);
        return addr;
    }

    public RendAddrCompactor(PeerGroup pg, Vector initialCompactorParams) {
        this.myGroup = pg;
        this.initialParams = initialCompactorParams;
        this.endpoint = this.myGroup.getEndpointService();
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.rdvListener = new RdvListener(this);
        RefPeerGroup parent = ((RefPeerGroup)this.myGroup).getParentGroup();
        this.discovery = parent != null ? parent.getDiscoveryService() : this.myGroup.getDiscoveryService();
        this.rendezvous = this.myGroup.getRendezVousService();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Start compacting");
        }
        this.myThread = new Thread((Runnable)this, "RendezvousService:RendezvousCompactor");
        this.myThread.start();
    }

    public void shutdown() {
        this.stopping = true;
        this.myThread.interrupt();
    }

    public void run() {
        try {
            Vector params = (Vector)this.initialParams.clone();
            RdvMonitor monitor = new RdvMonitor(this.myGroup, (RendezVousServiceImpl)this.rendezvous);
            this.rendezvous.setMonitor(monitor);
            RefPeerGroup grandPa = null;
            RefPeerGroup parent = ((RefPeerGroup)this.myGroup).getParentGroup();
            if (parent != null) {
                grandPa = parent.getParentGroup();
            }
            if (grandPa == null) {
                if (params != null) {
                    int i = 0;
                    while (i < params.size()) {
                        block27: {
                            String str = (String)params.elementAt(i);
                            EndpointAddress address = this.endpoint.newEndpointAddress(str);
                            try {
                                this.rendezvous.connectToRendezVous(address);
                            }
                            catch (Exception e) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block27;
                                LOG.debug((Object)("Cannot connect to Rendezvous at " + str + ":" + e));
                            }
                        }
                        ++i;
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Network peergroup Done compacting");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Regular group... Find rendezvous");
            }
            String pgId = this.myGroup.getPeerGroupID().toString();
            params = this.searchLocal(pgId);
            this.connect(params, 5);
            Object enum_ = null;
            Enumeration rdvsEnum = null;
            Vector rdvs = null;
            boolean count = false;
            while (true) {
                if (this.stopping) {
                    return;
                }
                rdvsEnum = this.rendezvous.getConnectedRendezVous();
                if (!rdvsEnum.hasMoreElements()) {
                    rdvs = null;
                } else {
                    rdvs = new Vector();
                    while (rdvsEnum.hasMoreElements()) {
                        try {
                            rdvs.addElement(rdvsEnum.nextElement());
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                }
                boolean connected = false;
                if (rdvs != null && rdvs.size() > 0) {
                    connected = true;
                }
                this.searchRemote(pgId);
                if (connected && rdvs.size() >= 3) {
                    try {
                        Thread.sleep(2400000L);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)("Exception " + e));
                    }
                    continue;
                }
                if (connected) {
                    try {
                        Thread.sleep(1200000L);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)("Exception " + e));
                    }
                    continue;
                }
                try {
                    Thread.sleep(600000L);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("Exception " + e));
                }
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread: " + Thread.currentThread().getName()), all);
            }
            return;
        }
    }

    protected void processRdvAdv(Vector rdvs) {
        if (rdvs == null || rdvs.size() == 0) {
            return;
        }
        Vector connectedRdvs = new Vector();
        Enumeration rdvsEnum = null;
        rdvsEnum = this.rendezvous.getConnectedRendezVous();
        if (rdvsEnum != null && rdvsEnum.hasMoreElements()) {
            while (rdvsEnum.hasMoreElements()) {
                try {
                    connectedRdvs.addElement(rdvsEnum.nextElement());
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        if ((rdvsEnum = this.rendezvous.getConnectedPeers()) != null && rdvsEnum.hasMoreElements()) {
            while (rdvsEnum.hasMoreElements()) {
                try {
                    connectedRdvs.addElement(rdvsEnum.nextElement());
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < rdvs.size()) {
            block13: {
                try {
                    RdvAdvertisement adv = (RdvAdvertisement)rdvs.elementAt(i);
                    String peer = adv.getPeerID().toString();
                    if (!connectedRdvs.contains(peer)) {
                        result.add(peer);
                    }
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                    LOG.debug((Object)"processRdvAdv failed ", (Throwable)ez1);
                }
            }
            ++i;
        }
        this.connect(result, 1);
    }

    private void connect(Vector params, int nbOfThreads) {
        if (params == null || params.size() == 0) {
            return;
        }
        String peerId = null;
        Stack<EndpointAddress> addrs = new Stack<EndpointAddress>();
        int i = 0;
        while (i < params.size()) {
            block10: {
                try {
                    peerId = (String)params.elementAt(i);
                    if (!peerId.equals(this.localPeerId)) {
                        try {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"  Connecting...");
                            }
                            EndpointAddress address = this.mkAddress(peerId);
                            addrs.push(address);
                        }
                        catch (Exception e) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Cannot connect to Rendezvous at " + peerId));
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("  failed with " + ex));
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nbOfThreads) {
            Thread th = new Thread((Runnable)new ConnectThread(addrs, this.rendezvous, this), "Rendezvous Connect Thread");
            th.start();
            Thread.currentThread();
            Thread.yield();
            ++i2;
        }
    }

    private void searchRemote(String gid) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"searching remote");
        }
        if (gid == null) {
            return;
        }
        this.discovery.getRemoteAdvertisements(null, 2, "RdvGroupId", gid, 3, this.rdvListener);
    }

    private Vector searchLocal(String gid) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"searching local");
        }
        if (gid == null) {
            return null;
        }
        Enumeration advs = null;
        try {
            advs = this.discovery.getLocalAdvertisements(2, "RdvGroupId", gid);
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Caught IOException");
            }
            return null;
        }
        if (advs == null || !advs.hasMoreElements()) {
            return null;
        }
        Vector<String> rdvs = new Vector<String>();
        while (advs.hasMoreElements()) {
            try {
                RdvAdvertisement radv = (RdvAdvertisement)advs.nextElement();
                rdvs.addElement(radv.getPeerID().toString());
            }
            catch (Exception all) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("Failed with " + all));
            }
        }
        return rdvs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ RendezVousService access$000(RendAddrCompactor x0) {
        return x0.rendezvous;
    }

    static /* synthetic */ Category access$100() {
        return LOG;
    }

    class RdvListener
    implements DiscoveryListener {
        private RendAddrCompactor caller = null;

        public RdvListener(RendAddrCompactor caller) {
            this.caller = caller;
        }

        public void discoveryEvent(DiscoveryEvent e) {
            DiscoveryResponseMsg rep = e.getResponse();
            Enumeration enumeration = rep.getResponses();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            boolean changed = false;
            Vector<RdvAdvertisement> rdvs = new Vector<RdvAdvertisement>();
            while (enumeration.hasMoreElements()) {
                try {
                    String advString = (String)enumeration.nextElement();
                    RdvAdvertisement adv = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(advString.getBytes()));
                    if (adv == null) continue;
                    rdvs.add(adv);
                }
                catch (Exception ez1) {
                    // empty catch block
                }
            }
            if (rdvs.size() > 0) {
                this.caller.processRdvAdv(rdvs);
            }
        }
    }

    protected class ConnectThread
    implements Runnable {
        private Stack addrs = null;
        private RendezVousService rdv = null;
        private RendAddrCompactor compactor = null;

        public ConnectThread(Stack addrs, RendezVousService rdv, RendAddrCompactor compactor) {
            this.addrs = addrs;
            this.rdv = rdv;
            this.compactor = compactor;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            rdvsEnum = RendAddrCompactor.access$000(RendAddrCompactor.this).getConnectedRendezVous();
            nbOfRdvs = 0;
            if (rdvsEnum != null) {
                try {
                    while (rdvsEnum.hasMoreElements()) {
                        rdvsEnum.nextElement();
                        ++nbOfRdvs;
                    }
                }
                catch (Exception ez1) {
                    // empty catch block
                }
                if (nbOfRdvs >= 3) {
                    return;
                }
            }
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.addrs.size() <= 0) {
                        return;
                    }
                    if (this.compactor.stopping) {
                        return;
                    }
                    try {
                        addr = (EndpointAddress)this.addrs.pop();
                        this.rdv.connectToRendezVous(addr);
                    }
                    catch (EmptyStackException e1) {
                        return;
                    }
                    catch (Exception e2) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable all) {
                if (RendAddrCompactor.access$100().isEnabledFor(Priority.FATAL) == false) return;
                RendAddrCompactor.access$100().fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            ** GOTO lbl-1000
        }
    }
}

