/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PipeAdvertisement;

public class PipeAdv
extends PipeAdvertisement {
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PipeAdv() {
    }

    public PipeAdv(PipeID pipeId) {
        this.setPipeID(pipeId);
        this.setType("JxtaUnicast");
    }

    public PipeAdv(PipeID pipeId, String name) {
        this.setPipeID(pipeId);
        this.setName(name);
        this.setType("JxtaUnicast");
    }

    public PipeAdv(Element root) {
        this.initialize(root);
    }

    private void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PipeAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(PipeAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + PipeAdvertisement.getAdvertisementType());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals("Id")) {
                try {
                    URL pipeID = new URL(elem.getTextValue());
                    this.setPipeID(IDFactory.fromURL(pipeID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elem.getName().equals("Name")) {
                this.setName(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals("Type")) continue;
            this.setType(elem.getTextValue());
        }
        if (this.getPipeID().equals(ID.nullID)) {
            throw new IllegalArgumentException("Bad pipe ID in advertisement");
        }
    }

    public Document getDocument(MimeMediaType mediaType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mediaType, PipeAdvertisement.getAdvertisementType());
        if (this.getPipeID().equals(ID.nullID)) {
            throw new IllegalStateException("Pipe has no assigned ID");
        }
        TextElement e = adv.createElement("Id", this.getPipeID().toString());
        adv.appendChild(e);
        e = adv.createElement("Type", this.getType());
        adv.appendChild(e);
        if (this.getName() != null) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PipeAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PipeAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PipeAdv(root);
        }
    }
}

