/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.PeerAdvertisement;

public class PeerAdv
extends PeerAdvertisement {
    private static Class xxx = class$net$jxta$peergroup$PeerGroupID == null ? (class$net$jxta$peergroup$PeerGroupID = PeerAdv.class$("net.jxta.peergroup.PeerGroupID")) : class$net$jxta$peergroup$PeerGroupID;
    private static final String nameTag = "Name";
    private static final String pidTag = "PID";
    private static final String gidTag = "GID";
    private static final String descTag = "Desc";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String paramTag = "Parm";
    private static final String debugTag = "Dbg";
    static /* synthetic */ Class class$net$jxta$peergroup$PeerGroupID;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PeerAdv() {
    }

    public PeerAdv(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PeerAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(PeerAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(nameTag)) {
                this.setName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(descTag)) {
                this.setDescription(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(pidTag)) {
                try {
                    URL pID = new URL(elem.getTextValue());
                    this.setPeerID((PeerID)IDFactory.fromURL(pID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elem.getName().equals(gidTag)) {
                try {
                    URL gID = new URL(elem.getTextValue());
                    this.setPeerGroupID((PeerGroupID)IDFactory.fromURL(gID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerGroupID ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elem.getName().equals(debugTag)) {
                this.setDebugLevel(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(svcTag)) continue;
            Enumeration elems = elem.getChildren();
            String classID = null;
            TextElement param = null;
            while (elems.hasMoreElements()) {
                TextElement e = (TextElement)elems.nextElement();
                if (e.getName().equals(mcidTag)) {
                    classID = e.getTextValue();
                    continue;
                }
                if (!e.getName().equals(paramTag)) continue;
                param = e;
            }
            if (classID == null || param == null) continue;
            try {
                this.putServiceParam(IDFactory.fromURL(new URL(classID)), param);
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        Element e;
        StructuredTextDocument adv = null;
        try {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PeerAdvertisement.getAdvertisementType());
        }
        catch (Throwable everything) {
            return null;
        }
        if (this.getPeerID() != null) {
            e = adv.createElement(pidTag, this.getPeerID().toString());
            adv.appendChild(e);
        }
        if (this.getPeerGroupID() != null) {
            e = adv.createElement(gidTag, this.getPeerGroupID().toString());
            adv.appendChild(e);
        }
        if (this.getName() != null) {
            e = adv.createElement(nameTag, this.getName());
            adv.appendChild(e);
        }
        if (this.getDebugLevel() != null) {
            e = adv.createElement(debugTag, this.getDebugLevel());
            adv.appendChild(e);
        }
        if (this.getDescription() != null) {
            e = adv.createElement(descTag, this.getDescription());
            adv.appendChild(e);
        }
        Hashtable serviceParams = this.getServiceParams();
        Enumeration classIds = serviceParams.keys();
        while (classIds.hasMoreElements()) {
            ModuleClassID classId = (ModuleClassID)classIds.nextElement();
            TextElement s = adv.createElement(svcTag);
            adv.appendChild((Element)s);
            e = adv.createElement(mcidTag, classId.toString());
            s.appendChild(e);
            e = (Element)serviceParams.get(classId);
            StructuredDocumentUtils.copyElements(adv, s, e);
        }
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PeerAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PeerAdv(root);
        }
    }
}

