/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryResponseMsg;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class DiscoveryResponse
extends DiscoveryResponseMsg {
    private static final String countTag = "Count";
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String responsesTag = "Response";
    private static final String expirationTag = "Expiration";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$protocol$DiscoveryResponse == null ? (class$net$jxta$impl$protocol$DiscoveryResponse = DiscoveryResponse.class$("net.jxta.impl.protocol.DiscoveryResponse")) : class$net$jxta$impl$protocol$DiscoveryResponse).getName());
    static /* synthetic */ Class class$net$jxta$impl$protocol$DiscoveryResponse;

    public DiscoveryResponse(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), stream);
        this.readIt(doc);
    }

    public DiscoveryResponse(TextElement doc) {
        if (!DiscoveryResponseMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public void readIt(TextElement doc) {
        Vector<Long> exps;
        Vector<Object> res;
        block12: {
            res = new Vector<Object>();
            exps = new Vector<Long>();
            try {
                res.removeAllElements();
                Enumeration elements = doc.getChildren();
                while (elements.hasMoreElements()) {
                    long exp;
                    TextElement elem = (TextElement)elements.nextElement();
                    if (elem.getName().equals(countTag)) {
                        this.count = Integer.parseInt(elem.getTextValue());
                        continue;
                    }
                    if (elem.getName().equals(typeTag)) {
                        this.type = Integer.parseInt(elem.getTextValue());
                        continue;
                    }
                    if (elem.getName().equals(peerAdvTag)) {
                        this.setPeerAdv(elem.getTextValue());
                        continue;
                    }
                    if (elem.getName().equals(queryAttrTag)) {
                        this.setQueryAttr(elem.getTextValue());
                        continue;
                    }
                    if (elem.getName().equals(queryValueTag)) {
                        this.setQueryValue(elem.getTextValue());
                        continue;
                    }
                    if (!elem.getName().equals(responsesTag)) continue;
                    res.addElement(elem.getValue());
                    Attribute attr = ((Attributable)((Object)elem)).getAttribute(expirationTag);
                    if (null == attr) {
                        exps.addElement(new Long(0x6DDD00L));
                        continue;
                    }
                    String expstr = attr.getValue();
                    if (null != expstr) {
                        exp = Long.parseLong(expstr);
                    } else {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Received an old-style DiscoveryResponse.\n You received a response from a peer that does \nnot support advertisement aging. \nSetting expiration to DiscoveryService.DEFAULT_EXPIRATION ");
                        }
                        exp = 0x6DDD00L;
                    }
                    exps.addElement(new Long(exp));
                }
            }
            catch (Exception mye) {
                if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)"Got an Exception during Parse ", (Throwable)mye);
            }
        }
        this.setResponses(res);
        this.setExpirations(exps);
    }

    public DiscoveryResponse(int count, int type, String peeradv, String attr, String value, Vector responses, Vector expirations) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("DiscoveryResponse.<init>:  response count = " + responses.size()));
        }
        this.setResponseCount(count);
        this.setDiscoveryType(type);
        this.setPeerAdv(peeradv);
        this.setQueryAttr(attr);
        this.setQueryValue(value);
        this.setResponses(responses);
        this.setExpirations(expirations);
    }

    public Document getDocument(MimeMediaType asMimeType) throws Exception {
        StructuredTextDocument adv;
        block3: {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryResponseMsg.getAdvertisementType());
            TextElement e = adv.createElement(countTag, Integer.toString(this.count));
            adv.appendChild((Element)e);
            e = adv.createElement(typeTag, Integer.toString(this.type));
            adv.appendChild((Element)e);
            e = adv.createElement(peerAdvTag, this.getPeerAdv());
            adv.appendChild((Element)e);
            e = adv.createElement(queryAttrTag, this.getQueryAttr());
            adv.appendChild((Element)e);
            e = adv.createElement(queryValueTag, this.getQueryValue());
            adv.appendChild((Element)e);
            Enumeration advs = this.getResponses();
            Enumeration exps = this.getExpirations();
            try {
                while (advs.hasMoreElements()) {
                    Long l = (Long)exps.nextElement();
                    e = adv.createElement(responsesTag, (String)advs.nextElement());
                    adv.appendChild((Element)e);
                    ((Attributable)((Object)e)).addAttribute(expirationTag, l.toString());
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Got an Exception during doc creation ", (Throwable)ex);
            }
        }
        return adv;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Got an Exception during Parse ", (Throwable)e);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

