/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.config.Config;
import net.jxta.impl.peergroup.Configurator;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Platform
extends StdPeerGroup {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$Platform == null ? (class$net$jxta$impl$peergroup$Platform = Platform.class$("net.jxta.impl.peergroup.Platform")) : class$net$jxta$impl$peergroup$Platform).getName());
    Configurator config;
    private boolean initialized = false;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$Platform;

    private ModuleImplAdvertisement mkPlatformImplAdv() throws Exception {
        ModuleImplAdvertisement platformDef = this.mkImplAdvBuiltin(PeerGroup.refPlatformSpecID, "net.jxta.impl.peergroup.Platform", "Standard Platform Reference Implementation");
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> protos = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> services = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> apps = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        ModuleImplAdvertisement moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refResolverSpecID, "net.jxta.impl.resolver.ResolverServiceImpl", "Reference Implementation of the ResolverService service");
        services.put(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refDiscoverySpecID, "net.jxta.impl.discovery.DiscoveryServiceImpl", "Reference Implementation of the DiscoveryService service");
        services.put(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPipeSpecID, "net.jxta.impl.pipe.PipeServiceImpl", "Reference Implementation of the PipeService service");
        services.put(PeerGroup.pipeClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refMembershipSpecID, "net.jxta.impl.membership.NullMembershipService", "Reference Implementation of the MembershipService service");
        services.put(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRendezvousSpecID, "net.jxta.impl.rendezvous.RendezVousServiceImpl", "Reference Implementation of the Rendezvous service");
        services.put(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPeerinfoSpecID, "net.jxta.impl.peer.PeerInfoServiceImpl", "Reference Implementation of the Peerinfo service");
        services.put(PeerGroup.peerinfoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refProxySpecID, "net.jxta.impl.proxy.ProxyService", "Reference Implementation of the Proxy service");
        services.put(PeerGroup.proxyClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refEndpointSpecID, "net.jxta.impl.endpoint.EndpointServiceImpl", "Reference Implementation of the EndpointService service");
        services.put(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refTcpProtoSpecID, "net.jxta.impl.endpoint.tcp.TcpTransport", "Reference Implementation of the Tcp Proto");
        protos.put(PeerGroup.tcpProtoClassID, moduleAdv);
        String httpTransportClassname = "net.jxta.impl.endpoint.servlethttp.ServletHttpTransport";
        String moduleDescription = "Reference Implementation of the Http Proto";
        String httpTransportProp = System.getProperty("HTTP_TRANSPORT");
        if (httpTransportProp != null) {
            httpTransportClassname = httpTransportProp;
            moduleDescription = "Alernate Http Proto implementation";
        }
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refHttpProtoSpecID, httpTransportClassname, moduleDescription);
        protos.put(PeerGroup.httpProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRouterProtoSpecID, "net.jxta.impl.endpoint.EndpointRouter", "Reference Implementation of the Router");
        protos.put(PeerGroup.routerProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refTlsProtoSpecID, "net.jxta.impl.endpoint.tls.TlsTransport", "Reference Implementation of the JXTA TLS Transport");
        protos.put(PeerGroup.tlsProtoClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refStartNetPeerGroupSpecID, "net.jxta.impl.peergroup.StartNetPeerGroup", "Reference Implementation of StartNetPeerGroup");
        apps.put(PeerGroup.applicationClassID, moduleAdv);
        paramAdv.setServices(services);
        paramAdv.setProtos(protos);
        paramAdv.setApps(apps);
        platformDef.setParam((StructuredDocument)paramAdv.getDocument(new MimeMediaType("text", "xml")));
        return platformDef;
    }

    public void init(PeerGroup nullParent, ID nullID, Advertisement nullAdv) throws PeerGroupException {
        ModuleImplAdvertisement platformDef;
        if (this.initialized) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"You cannot initialize a PeerGroup more than once !");
            }
            return;
        }
        this.initialized = true;
        if (nullAdv != null && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"Platform has full control over its adv.");
        }
        this.config = new Configurator();
        this.setConfigAdvertisement(this.config.get());
        this.config.setReconf();
        try {
            platformDef = this.mkPlatformImplAdv();
        }
        catch (Exception e) {
            throw new PeerGroupException(e.getMessage());
        }
        super.init(null, PeerGroupID.worldPeerGroupID, platformDef);
        try {
            this.publishGroup("jxta.peergroup.PlatformGroup", "The Universal Platform PeerGroup");
        }
        catch (IOException e) {
            throw new PeerGroupException(e.getMessage());
        }
        this.config.clearReconf();
        new File(Config.JXTA_HOME).mkdirs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            PeerGroupFactory.setPlatformClass(Class.forName("net.jxta.impl.peergroup.Platform"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

