/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.id.IDFactory;
import net.jxta.impl.config.Config;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.peergroup.ConfigDialog;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Configurator {
    static String configName = Config.JXTA_HOME + "PlatformConfig";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$Configurator == null ? (class$net$jxta$impl$peergroup$Configurator = Configurator.class$("net.jxta.impl.peergroup.Configurator")) : class$net$jxta$impl$peergroup$Configurator).getName());
    PeerAdvertisement advertisement;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$Configurator;

    public Configurator() {
        block11: {
            BufferedReader in;
            this.advertisement = null;
            this.load();
            if (!this.fixAdvertisement()) {
                this.adjustLog4JPriority();
                this.checkPassword();
                this.configureTls();
                this.routerRdvMatch();
                return;
            }
            try {
                ConfigDialog ignore = new ConfigDialog(this.advertisement);
                ignore.untilDone();
                break block11;
            }
            catch (Throwable t) {
                if (t instanceof JxtaError) {
                    throw (JxtaError)t;
                }
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Could not initialize graphical config dialog", t);
                }
                in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    while (in.ready()) {
                        in.readLine();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            System.out.println("The window-based configurator does not seem to be usable.");
            System.out.print("Do you want to stop and edit the current configuration ? [no]: ");
            String answer = "no";
            try {
                answer = in.readLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("yes".equalsIgnoreCase(answer)) {
                this.save();
                System.out.println("Exiting; edit the file \"" + configName + "\", remove the file \"reconf\", and then" + ", launch JXTA again.");
                throw new JxtaError("Manual Configuration Requested");
            }
            this.save();
            this.routerRdvMatch();
            System.out.println("Using the current configuration.");
        }
        this.adjustLog4JPriority();
        this.checkPassword();
        this.configureTls();
        this.addRootCert();
        this.save();
        this.routerRdvMatch();
    }

    private void checkPassword() {
        String password = System.getProperty("net.jxta.tls.password");
        String principal = System.getProperty("net.jxta.tls.principal");
        if (password != null && principal != null) {
            return;
        }
        if (JTlsUtil.passwdExists()) {
            try {
                new PasswordDialog();
            }
            catch (Throwable t) {
                System.out.println("The window-based authenticator does not seem to be usable.");
                System.out.println("You must authenticate through the command-line.");
                throw new JxtaError("Could not authenticate.");
            }
        }
    }

    private void configureTls() {
        String peerName = this.advertisement.getName();
        String password = System.getProperty("net.jxta.tls.password");
        String principal = System.getProperty("net.jxta.tls.principal");
        System.setProperty("net.jxta.tls.password", "");
        TlsConfig.init(principal, password);
    }

    public void addRootCert() {
        StructuredTextDocument paramDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        String rootCert = null;
        try {
            rootCert = TlsConfig.getRootCert();
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Cannot get root cert, Exception = ", (Throwable)e);
            }
            return;
        }
        TextElement e = paramDoc.createElement("RootCert", rootCert);
        paramDoc.appendChild((Element)e);
        this.advertisement.putServiceParam(PeerGroup.peerGroupClassID, paramDoc);
    }

    private void routerRdvMatch() {
        try {
            boolean httpDisabled;
            HTTPAdv httpAdv;
            Vector<String> rdvs;
            Enumeration rdvElements;
            block21: {
                rdvElements = null;
                rdvs = new Vector<String>();
                try {
                    TextElement param = (TextElement)((Object)this.advertisement.getServiceParam(PeerGroup.rendezvousClassID));
                    if (param != null) {
                        rdvElements = param.getChildren("Rdv");
                        Enumeration rdvEnum = param.getChildren("Addr");
                        while (rdvEnum.hasMoreElements()) {
                            rdvs.addElement(((TextElement)rdvEnum.nextElement()).getTextValue());
                        }
                    }
                }
                catch (Exception nobigdeal) {
                    // empty catch block
                }
                httpAdv = null;
                httpDisabled = false;
                try {
                    Enumeration httpChilds;
                    Element param = this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                    if (param.getChildren("isOff").hasMoreElements()) {
                        httpDisabled = true;
                    }
                    if ((httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                        param = (Element)httpChilds.nextElement();
                    } else {
                        httpChilds = param.getChildren(HTTPAdv.getAdvertisementType());
                        if (httpChilds.hasMoreElements()) {
                            param = (Element)httpChilds.nextElement();
                        }
                    }
                    httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                }
                catch (Exception nevermind) {
                    httpAdv = new HTTPAdv();
                    httpAdv.setProtocol("http");
                    httpAdv.setPort("9700");
                    httpAdv.setRouterEnabled(true);
                    httpAdv.setProxyEnabled(false);
                    httpAdv.setServerEnabled(false);
                    if (!LOG.isEnabledFor(Priority.WARN)) break block21;
                    LOG.warn((Object)"httpAdv has vanished");
                }
            }
            Vector routers = httpAdv.getRouters();
            if (routers == null) {
                routers = new Vector();
            }
            Vector<String> intRouters = new Vector<String>();
            Vector<String> intRdvs = new Vector<String>();
            int intersectSz = 0;
            PosRandom random = new PosRandom();
            Enumeration eRdvs = rdvs.elements();
            while (eRdvs.hasMoreElements()) {
                String rdv = (String)eRdvs.nextElement();
                if (rdv.startsWith("tcp://")) continue;
                rdv = rdv.substring(7);
                Enumeration eRouters = routers.elements();
                boolean found = true;
                if (httpAdv.getRouterEnabled()) {
                    found = false;
                    while (eRouters.hasMoreElements()) {
                        String router = (String)eRouters.nextElement();
                        if (!rdv.equals(router)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                int here = random.nextPos() % ++intersectSz;
                intRouters.insertElementAt(rdv, here);
                intRdvs.insertElementAt("http://" + rdv, here);
            }
            int range = 0;
            int front = !httpDisabled ? intersectSz : 0;
            eRdvs = rdvs.elements();
            while (eRdvs.hasMoreElements()) {
                String rdv = (String)eRdvs.nextElement();
                if (rdv.startsWith("http://")) continue;
                intRdvs.insertElementAt(rdv, random.nextPos() % ++range + front);
            }
            if (intRouters.size() == 0) {
                intRouters = null;
            }
            httpAdv.setRouters(intRouters);
            StructuredTextDocument newRdvs = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            if (rdvElements != null || rdvElements.hasMoreElements()) {
                StructuredDocumentUtils.copyElements(newRdvs, newRdvs, (Element)rdvElements.nextElement());
            }
            Enumeration rdvEnum = intRdvs.elements();
            while (rdvEnum.hasMoreElements()) {
                TextElement e = newRdvs.createElement("Addr", (String)rdvEnum.nextElement());
                newRdvs.appendChild((Element)e);
            }
            StructuredDocument http = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            StructuredDocumentUtils.copyElements(http, http, (StructuredDocument)httpAdv.getDocument(new MimeMediaType("text", "xml")));
            if (httpDisabled) {
                http.appendChild(http.createElement("isOff"));
            }
            this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, http);
            this.advertisement.putServiceParam(PeerGroup.rendezvousClassID, newRdvs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PeerAdvertisement get() {
        return this.advertisement;
    }

    public void save() {
        this.saveTo(configName);
    }

    public void load() {
        this.loadFrom(configName);
    }

    public void setReconf() {
        block2: {
            try {
                File file = new File("reconf");
                new FileOutputStream(file).close();
            }
            catch (Exception ex1) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"Could not create reconfig flag.");
                LOG.error((Object)"Create the file reconfig by hand before retrying.");
            }
        }
    }

    public void clearReconf() {
        block2: {
            try {
                File file = new File("reconf");
                file.delete();
            }
            catch (Exception ex1) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"Could not remove reconfig flag.");
                LOG.error((Object)"Delete the file reconfig by hand before retrying.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReconf() {
        try {
            void ex1;
            File file = new File("reconf");
            boolean forceReconfig = file.exists();
            if (forceReconfig && LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Reconfig requested - 'reconf' file found");
            }
            return (boolean)ex1;
        }
        catch (Exception ex1) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Could not check reconfig flag.");
                LOG.error((Object)"Assuming it exists.");
            }
            return true;
        }
    }

    private void loadFrom(String fileName) {
        FileInputStream advStream = null;
        File file = null;
        try {
            file = new File(fileName);
            advStream = new FileInputStream(file);
            this.advertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), advStream);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Recovered " + fileName));
            }
        }
        catch (FileNotFoundException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("No Existing " + fileName));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Failed to Recover " + fileName));
            }
            e.printStackTrace();
            try {
                file.delete();
            }
            catch (Exception ex1) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Could not remove " + fileName + ". Removed it by hand before retrying"));
                }
                throw new JxtaError("Could not remove " + fileName + ". Removed it by hand before retrying");
            }
            this.advertisement = null;
        }
        try {
            if (advStream != null) {
                advStream.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void saveTo(String fileName) {
        FileOutputStream out;
        block4: {
            String parent = new File(fileName).getParent();
            new File(parent).mkdirs();
            out = null;
            try {
                out = new FileOutputStream(fileName);
                Document aDoc = this.advertisement.getDocument(new MimeMediaType("text/xml"));
                aDoc.sendToStream(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)("Could not save to " + fileName));
            }
        }
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String parseHttpProxyServer(String proxy) {
        if (proxy.indexOf(";") >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(proxy, ";");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                if (!token.startsWith("http=")) continue;
                return token;
            }
        }
        return proxy;
    }

    private boolean fixAdvertisement() {
        block48: {
            try {
                String winProxy;
                String cfMode;
                int i;
                InetAddress[] all;
                String hostAddr;
                String interfaceAddress;
                boolean found;
                Element param;
                boolean reconf = this.isReconf();
                if (this.advertisement == null) {
                    reconf = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - no PeerAdvertisement");
                    }
                    this.advertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
                    this.advertisement.setName("");
                    this.advertisement.setDescription("");
                    this.advertisement.setPeerID(IDFactory.newPeerID(PeerGroupID.worldPeerGroupID));
                    StructuredTextDocument proxy = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                    proxy.appendChild(proxy.createElement("isOff"));
                    this.advertisement.putServiceParam(PeerGroup.proxyClassID, proxy);
                }
                StructuredDocument http = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.httpProtoClassID);
                StructuredDocument tcp = (StructuredTextDocument)this.advertisement.getServiceParam(PeerGroup.tcpProtoClassID);
                HTTPAdv httpAdv = null;
                boolean httpDisabled = false;
                TCPAdv tcpAdv = null;
                boolean tcpDisabled = false;
                if (http != null) {
                    try {
                        block46: {
                            httpDisabled = http.getChildren("isOff").hasMoreElements();
                            param = null;
                            Enumeration httpChilds = http.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (httpChilds.hasMoreElements()) {
                                param = (Element)httpChilds.nextElement();
                            } else {
                                httpChilds = http.getChildren(HTTPAdv.getAdvertisementType());
                                if (httpChilds.hasMoreElements()) {
                                    param = (Element)httpChilds.nextElement();
                                }
                            }
                            httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                            found = false;
                            try {
                                interfaceAddress = httpAdv.getInterfaceAddress();
                                if (interfaceAddress == null || interfaceAddress.equals("")) break block46;
                                hostAddr = InetAddress.getLocalHost().getHostAddress();
                                all = InetAddress.getAllByName(hostAddr);
                                i = all.length;
                                while (i-- > 0) {
                                    if (!all[i].getHostAddress().equals(interfaceAddress)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                        }
                        if (!(found || (cfMode = httpAdv.getConfigMode()) != null && cfMode.equals("manual"))) {
                            reconf = true;
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Reconfig requested - http set to manual config");
                            }
                        }
                    }
                    catch (Exception advTrouble) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)advTrouble);
                        }
                        httpAdv = null;
                    }
                }
                if (httpAdv == null) {
                    reconf = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - http advertisement missing");
                    }
                    httpAdv = new HTTPAdv();
                    httpAdv.setProtocol("http");
                    httpAdv.setPort("9700");
                    httpAdv.setRouterEnabled(true);
                    httpAdv.setProxyEnabled(false);
                    httpAdv.setServerEnabled(false);
                }
                if (tcp != null) {
                    try {
                        block47: {
                            tcpDisabled = tcp.getChildren("isOff").hasMoreElements();
                            param = null;
                            Enumeration tcpChilds = tcp.getChildren(TransportAdvertisement.getAdvertisementType());
                            if (tcpChilds.hasMoreElements()) {
                                param = (Element)tcpChilds.nextElement();
                            } else {
                                tcpChilds = tcp.getChildren(TCPAdv.getAdvertisementType());
                                if (tcpChilds.hasMoreElements()) {
                                    param = (Element)tcpChilds.nextElement();
                                }
                            }
                            tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                            found = false;
                            try {
                                interfaceAddress = tcpAdv.getInterfaceAddress();
                                if (interfaceAddress == null || interfaceAddress.equals("")) break block47;
                                hostAddr = InetAddress.getLocalHost().getHostAddress();
                                all = InetAddress.getAllByName(hostAddr);
                                i = all.length;
                                while (i-- > 0) {
                                    if (!all[i].getHostAddress().equals(interfaceAddress)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                        }
                        if (!(found || (cfMode = tcpAdv.getConfigMode()) != null && cfMode.equals("manual"))) {
                            reconf = true;
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Reconfig requested - tcp set to manual config");
                            }
                        }
                    }
                    catch (Exception advTrouble) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Reconfig requested - http advertisement corrupted", (Throwable)advTrouble);
                        }
                        tcpAdv = null;
                    }
                }
                if (tcpAdv == null) {
                    reconf = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - tcp advertisement missing");
                    }
                    String port = "9701";
                    String tcpPort = System.getProperty("jxta.tcp.port");
                    if (tcpPort != null) {
                        port = tcpPort;
                    }
                    tcpAdv = new TCPAdv();
                    tcpAdv.setProtocol("TCP");
                    tcpAdv.setPort(port);
                    tcpAdv.setMulticastAddr("224.0.1.85");
                    tcpAdv.setMulticastPort("1234");
                    tcpAdv.setMulticastSize("16384");
                    tcpAdv.setServer("");
                    tcpAdv.setInterfaceAddress("");
                }
                String hn = "";
                try {
                    hn = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e) {
                    hn = "";
                }
                if (httpAdv.getServer() == null) {
                    httpAdv.setServer(hn + ":9700");
                    httpAdv.setServerEnabled(false);
                }
                if ((winProxy = System.getProperty("jxta.proxy")) != null) {
                    String proxyServer = this.parseHttpProxyServer(winProxy);
                    if (proxyServer != null) {
                        httpAdv.setProxyEnabled(true);
                        httpAdv.setProxy(proxyServer.substring(proxyServer.indexOf("=") + 1));
                    }
                } else if (httpAdv.getProxy() == null) {
                    httpAdv.setProxy("myProxy.myDomain:8080");
                    httpAdv.setProxyEnabled(false);
                }
                if (httpAdv.getRouters() == null) {
                    Vector r = new Vector();
                    httpAdv.setRouters(r);
                }
                if (TlsConfig.willConfigureTls()) {
                    reconf = true;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Reconfig requested - TLS wanted config");
                    }
                }
                if (!reconf) {
                    return false;
                }
                http = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                StructuredDocumentUtils.copyElements(http, http, (StructuredDocument)httpAdv.getDocument(new MimeMediaType("text", "xml")));
                if (httpDisabled) {
                    http.appendChild(http.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.httpProtoClassID, http);
                tcp = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                StructuredDocumentUtils.copyElements(tcp, tcp, (StructuredDocument)tcpAdv.getDocument(new MimeMediaType("text", "xml")));
                if (tcpDisabled) {
                    tcp.appendChild(tcp.createElement("isOff"));
                }
                this.advertisement.putServiceParam(PeerGroup.tcpProtoClassID, tcp);
            }
            catch (Exception serious) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block48;
                LOG.error((Object)"Trouble while fixing advertisement. Hope for the best.", (Throwable)serious);
            }
        }
        return true;
    }

    private void adjustLog4JPriority() {
        if (this.advertisement == null || this.advertisement.getDebugLevel() == null) {
            return;
        }
        String requestedLevel = this.advertisement.getDebugLevel();
        if ("user default".equals(requestedLevel)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"user default requested");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Setting priority to [" + requestedLevel + "] based on the user's configuration"));
        }
        Category jxtaCategory = Category.getInstance((String)"net.jxta");
        jxtaCategory.setPriority(Priority.toPriority((String)requestedLevel));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PosRandom
    extends Random {
        PosRandom() {
        }

        public int nextPos() {
            return this.next(31);
        }
    }

    class PasswordDialog
    extends JFrame
    implements ActionListener {
        TextField principalField = new TextField("", 20);
        TextField passwordField = new TextField(20);
        private boolean principalDone = false;
        private boolean passwordDone = false;

        public PasswordDialog() {
            super("JXTA Secure Login");
            JPanel contentPane = new JPanel(new BorderLayout());
            JPanel cp0 = new JPanel(new BorderLayout());
            JLabel pLabel = new JLabel("Secure Username: ");
            cp0.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            cp0.add((Component)pLabel, "West");
            cp0.add((Component)this.principalField, "East");
            JPanel cp1 = new JPanel(new BorderLayout());
            JLabel label = new JLabel("Password: ");
            this.passwordField.setEchoChar('*');
            cp1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            cp1.add((Component)label, "West");
            cp1.add((Component)this.passwordField, "East");
            this.principalField.addActionListener(this);
            this.passwordField.addActionListener(this);
            contentPane.add((Component)cp0, "North");
            contentPane.add((Component)cp1, "South");
            this.setContentPane(contentPane);
            Rectangle screenRect = this.getGraphicsConfiguration().getBounds();
            ((Component)this).setLocation(screenRect.x + screenRect.width / 2 - this.getSize().width / 2, screenRect.y + screenRect.height / 2 - this.getSize().height / 2);
            this.pack();
            ((Component)this).setVisible(true);
            this.untilDone();
            this.dispose();
        }

        private synchronized void untilDone() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void actionPerformed(ActionEvent e) {
            String password = this.passwordField.getText();
            String principal = this.principalField.getText();
            if (principal.length() == 0 || !JTlsUtil.principalIsIssuer(principal)) {
                JOptionPane.showMessageDialog(this, "Invalid Secure Username. Try again.", "Error Message", 0);
                return;
            }
            System.setProperty("net.jxta.tls.principal", principal);
            if (password.length() == 0) {
                this.passwordField.requestFocus();
                return;
            }
            if (password.length() == 0 || !JTlsUtil.validPasswd(password)) {
                JOptionPane.showMessageDialog(this, "Invalid Password. Try again.", "Error Message", 0);
                return;
            }
            System.setProperty("net.jxta.tls.password", password);
            this.notifyAll();
        }
    }
}

