/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PasswdMembershipService
extends MembershipService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$membership$PasswdMembershipService == null ? (class$net$jxta$impl$membership$PasswdMembershipService = PasswdMembershipService.class$("net.jxta.impl.membership.PasswdMembershipService")) : class$net$jxta$impl$membership$PasswdMembershipService).getName());
    public static final ModuleSpecID passwordMembershipSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000050206");
    private PeerGroup peergroup = null;
    private Vector principals = null;
    private Vector authCredentials = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable logins = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$PasswdMembershipService;

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.peergroup = group;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        PeerGroupAdvertisement configAdv = group.getPeerGroupAdvertisement();
        TextElement myParam = (TextElement)((Object)configAdv.getServiceParam(assignedID));
        this.logins = new Hashtable();
        if (null == myParam) {
            throw new PeerGroupException("parameters for group passwords missing");
        }
        Enumeration allLogins = myParam.getChildren();
        while (allLogins.hasMoreElements()) {
            String etcPasswd;
            int nextDelim;
            TextElement aLogin = (TextElement)allLogins.nextElement();
            if (!aLogin.getName().equals("login") || -1 == (nextDelim = (etcPasswd = aLogin.getTextValue()).indexOf(58))) continue;
            String login = etcPasswd.substring(0, nextDelim).trim();
            int lastDelim = etcPasswd.indexOf(58, nextDelim + 1);
            String passwd = etcPasswd.substring(nextDelim + 1, lastDelim);
            LOG.info((Object)("Adding login : '" + login + "' with encoded password : '" + passwd + "'"));
            this.logins.put(login, passwd);
        }
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Authenticator apply(AuthenticationCredential application) throws PeerGroupException, ProtocolNotSupportedException {
        String method = application.getMethod();
        if (null != method && !"PasswdAuthentication".equals(method)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new PasswdAuthenticator(this, application);
    }

    public synchronized Enumeration getCurrentCredentials() throws PeerGroupException {
        return this.principals.elements();
    }

    public synchronized Enumeration getAuthCredentials() throws PeerGroupException {
        return this.authCredentials.elements();
    }

    public synchronized Credential join(Authenticator authenticated) throws PeerGroupException {
        if (!(authenticated instanceof PasswdAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticated.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        if (!this.checkPasswd(((PasswdAuthenticator)authenticated).getAuth1Identity(), ((PasswdAuthenticator)authenticated).getAuth2_Password())) {
            throw new PeerGroupException("Incorrect Password!");
        }
        PasswdCredential newCred = new PasswdCredential(this, ((PasswdAuthenticator)authenticated).getAuth1Identity(), "blah");
        this.principals.addElement(newCred);
        this.authCredentials.addElement(authenticated.getAuthenticationCredential());
        return newCred;
    }

    public synchronized void resign() throws PeerGroupException {
        this.principals = new Vector();
        this.authCredentials = new Vector();
        this.principals.addElement(new PasswdCredential(this, "nobody", "blah"));
    }

    public Credential makeCredential(Element element) throws PeerGroupException, Exception {
        Object rootIs = element.getKey();
        if (!"PasswdCredential".equals(rootIs)) {
            throw new PeerGroupException("Element does not contain a recognized credential format");
        }
        Enumeration children = element.getChildren("PeerGroupID");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing PeerGroupID Element");
        }
        PeerGroupID peergroup = (PeerGroupID)IDFactory.fromURL(new URL((String)((Element)children.nextElement()).getValue()));
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra PeerGroupID Elements");
        }
        children = element.getChildren("PeerID");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        PeerID peer = (PeerID)IDFactory.fromURL(new URL((String)((Element)children.nextElement()).getValue()));
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra PeerID Elements");
        }
        children = element.getChildren("Identity");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        String whoami = (String)((Element)children.nextElement()).getValue();
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra Identity Elements");
        }
        children = element.getChildren("ReallyInsecureSignature");
        if (!children.hasMoreElements()) {
            throw new RuntimeException("Missing 'ReallyInsecureSignature' Element");
        }
        String signedPeerID = (String)((Element)children.nextElement()).getValue();
        if (children.hasMoreElements()) {
            throw new RuntimeException("Extra 'ReallyInsecureSignature' Elements");
        }
        return new PasswdCredential(this, peergroup, peer, whoami, signedPeerID);
    }

    private boolean checkPasswd(String identity, String passwd) {
        String mustMatch;
        if (!this.logins.containsKey(identity)) {
            return false;
        }
        String encodedPW = PasswdMembershipService.makePsswd(passwd);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Password '" + passwd + "' encodes as: '" + encodedPW + "'"));
        }
        if ((mustMatch = (String)this.logins.get(identity)).equals("")) {
            return true;
        }
        boolean result = encodedPW.equals(mustMatch);
        return result;
    }

    public static String makePsswd(String source) {
        String xlateTable = "DQKWHRTENOGXCVYSFJPILZABMU";
        StringBuffer work = new StringBuffer(source);
        int eachChar = work.length() - 1;
        while (eachChar >= 0) {
            char aChar = Character.toUpperCase(work.charAt(eachChar));
            int replaceIdx = "DQKWHRTENOGXCVYSFJPILZABMU".indexOf(aChar);
            if (-1 != replaceIdx) {
                work.setCharAt(eachChar, (char)(65 + replaceIdx));
            }
            --eachChar;
        }
        return work.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IdMaker {
        IdMaker() {
        }

        static ID mkID(String s) {
            try {
                return IDFactory.fromURL(new URL("urn", "", "jxta:uuid-" + s));
            }
            catch (MalformedURLException absurd) {
            }
            catch (UnknownServiceException unknownServiceException) {
                // empty catch block
            }
            throw new JxtaError("Hardcoded Spec and Class IDs are malformed.");
        }
    }

    public class PasswdAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = null;
        String password = null;

        PasswdAuthenticator(MembershipService source, AuthenticationCredential application) {
            this.source = source;
            this.application = application;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return null != this.password && null != this.whoami;
        }

        public String getMethodName() {
            return "PasswdAuthentication";
        }

        public void setAuth1Identity(String who) {
            this.whoami = who;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }

        public void setAuth2_Password(String secret) {
            this.password = secret;
        }

        private String getAuth2_Password() {
            return this.password;
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }
    }

    private class PasswdCredential
    implements Credential {
        PasswdMembershipService source;
        String whoami;
        ID peerid;
        String signedPeerID;

        protected PasswdCredential(PasswdMembershipService source, String whoami, String signedPeerID) {
            this.source = source;
            this.whoami = whoami;
            this.peerid = source.getPeerGroup().getPeerID();
            this.signedPeerID = signedPeerID;
        }

        protected PasswdCredential(PasswdMembershipService source, PeerGroupID peergroup, PeerID peer, String whoami, String signedPeerID) throws PeerGroupException {
            this.source = source;
            if (!source.getPeerGroup().getPeerGroupID().equals(peergroup)) {
                throw new PeerGroupException("Cannot credential for a different peer group.");
            }
            this.whoami = whoami;
            this.peerid = peer;
            this.signedPeerID = signedPeerID;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "PasswdCredential");
            Element e = doc.createElement("PeerGroupID", PasswdMembershipService.this.peergroup.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("PeerID", PasswdMembershipService.this.peergroup.getPeerID().toString());
            doc.appendChild(e);
            e = doc.createElement("Identity", this.whoami);
            doc.appendChild(e);
            e = doc.createElement("ReallyInsecureSignature", this.signedPeerID);
            doc.appendChild(e);
            return doc;
        }

        public String getIdentity() {
            return this.whoami;
        }
    }
}

