/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.util.Enumeration;
import java.util.Vector;

public class Expression {
    static final int LEFT_PAREN = 40;
    static final int RIGHT_PAREN = 41;
    static final int AT = 41;
    static final int EQUALS = 41;
    static final int QUOTED = 34;
    static final int IDENTIFIER = 128;
    static final int BINARY_OPERATOR = 129;
    static final int EOF = -1;
    static final int EXPRESSION = 64;
    static final int BINARY_EXPRESSION = 65;
    static final boolean DEBUG = false;
    int i = 0;
    char[] chars;
    String tokenValue;
    Node stackTop;
    int parens;
    LogicalExpression cnf;

    Expression(String s) {
        this.chars = s.toCharArray();
        Node expr = this.parse();
        if (expr instanceof BinaryExpression) {
            Clause rootClause = ((BinaryExpression)expr).toClause();
            this.cnf = Expression.toCNF(rootClause);
        } else {
            this.cnf = new Literal(expr.val);
        }
    }

    public static void main(String[] argv) {
        Expression expression = new Expression(argv[0]);
    }

    static Clause toCNF(Clause clause) {
        while (clause.getLayerCount() > 2 || clause.getLayerCount() == 2 && !clause.oper.equals("and")) {
            Expression.debug("Starting:" + clause);
            clause = clause.distribute("and");
            Expression.debug("Canonical: " + clause);
        }
        if (clause.getLayerCount() == 1) {
            if (clause.oper.equals("and")) {
                Enumeration e = clause.getSubexpressions();
                clause = new Clause("and");
                while (e.hasMoreElements()) {
                    clause.addSubexpression(new Clause("or").addLiteral((Literal)e.nextElement()));
                }
            } else if (clause.oper.equals("or")) {
                clause = new Clause("and").addSubexpression(clause);
            }
        }
        return clause;
    }

    static void debug(String msg) {
    }

    LogicalExpression getRootClause() {
        return this.cnf;
    }

    boolean isIdentifierPart(char c) {
        return " \t\r\n()".indexOf(c) == -1;
    }

    boolean isQuoteEscape(char c) {
        return c == '\\';
    }

    boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    void push(Node node) {
        if (this.stackTop == null) {
            this.stackTop = node;
        } else {
            node.next = this.stackTop;
            this.stackTop = node;
        }
    }

    Node pop() {
        Node ret = this.stackTop;
        this.stackTop = this.stackTop.next;
        ret.next = null;
        return ret;
    }

    boolean canReduceParenthesizedExpression() {
        boolean ret;
        boolean bl = ret = this.stackTop != null && this.stackTop.next != null && this.stackTop.type == 64 && this.stackTop.next.type == 40;
        if (!ret) {
            Expression.debug("Cannot reduce by parenthesized expr: " + this.stackTop.type + " " + this.stackTop.next.type + ", " + 64 + " " + 40);
        }
        return ret;
    }

    boolean canReduceBinaryExpression() {
        return this.stackTop != null && this.stackTop.next != null && this.stackTop.next.next != null && this.stackTop.type == 64 && this.stackTop.next.type == 129 && this.stackTop.next.next.type == 64;
    }

    Node reduceParenthesizedExpression() {
        Node expr = this.pop();
        Node leftParen = this.pop();
        return expr;
    }

    BinaryExpression reduceBinaryExpression(boolean flag) {
        Node expr2 = this.pop();
        Node oper = this.pop();
        Node expr1 = this.pop();
        if (flag) {
            this.pop();
        }
        return new BinaryExpression(expr1, oper, expr2);
    }

    void printStack() {
        Expression.debug("Stack:");
        Node node = this.stackTop;
        while (node != null) {
            Expression.debug(node.toString());
            node = node.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    Node parse() {
        int token;
        int state = 0;
        while ((token = this.lex()) != -1) {
            void var1_2;
            Expression.debug("Token " + (int)var1_2 + " value = " + this.tokenValue);
            switch (var1_2) {
                case 40: {
                    this.push(new Node(40, "("));
                    break;
                }
                case 41: {
                    if (this.canReduceBinaryExpression()) {
                        this.push(this.reduceBinaryExpression(true));
                        break;
                    }
                    if (this.canReduceParenthesizedExpression()) {
                        this.push(this.reduceParenthesizedExpression());
                        break;
                    }
                    throw new IllegalStateException("Misplaced )");
                }
                case 129: {
                    if (this.stackTop.type != 64) {
                        throw new IllegalStateException("Expression expected before " + this.tokenValue);
                    }
                    if (this.canReduceBinaryExpression()) {
                        Expression.debug("Reduction 2");
                        this.push(this.reduceBinaryExpression(false));
                    }
                    this.push(new Node(129, this.tokenValue));
                    state = 65;
                    break;
                }
                case 128: {
                    this.push(new Node(64, this.tokenValue));
                    if (state == 65) break;
                    state = 64;
                }
            }
            this.printStack();
        }
        if (this.canReduceBinaryExpression()) {
            Expression.debug("Reduced!");
            this.push(this.reduceBinaryExpression(false));
        } else {
            Expression.debug("Didn't reduce!");
        }
        this.printStack();
        if (this.stackTop != null && this.stackTop.next != null) {
            throw new IllegalStateException("Invalid expression.");
        }
        return this.stackTop;
    }

    int lex() {
        while (this.i < this.chars.length) {
            this.tokenValue = "" + this.chars[this.i];
            switch (this.chars[this.i]) {
                case '(': {
                    ++this.parens;
                    ++this.i;
                    return 40;
                }
                case ')': {
                    if (--this.parens < 0) {
                        throw new IllegalStateException("Unexpected )");
                    }
                    ++this.i;
                    return 41;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    int start;
                    this.i = start = this.i;
                    while (this.i < this.chars.length && this.isIdentifierPart(this.chars[this.i])) {
                        ++this.i;
                    }
                    this.tokenValue = new String(this.chars, start, this.i - start);
                    if (this.tokenValue.equalsIgnoreCase("and") || this.tokenValue.equalsIgnoreCase("or")) {
                        return 129;
                    }
                    return 128;
                }
            }
            ++this.i;
        }
        if (this.parens > 0) {
            throw new IllegalStateException("Some parens aren't closed.");
        }
        return -1;
    }

    public static interface LogicalExpression {
        public Clause distribute(LogicalExpression var1, String var2);

        public int getLayerCount();

        public String toString(String var1);
    }

    class BinaryExpression
    extends Node {
        Node expr1;
        Node oper;
        Node expr2;

        BinaryExpression(Node expr1, Node oper, Node expr2) {
            super(64, null);
            this.expr1 = expr1;
            this.oper = oper;
            this.expr2 = expr2;
        }

        public String toString() {
            return "(" + this.expr1.toString() + " " + this.oper.toString() + " " + this.expr2.toString() + ")";
        }

        Clause toClause() {
            Clause c = new Clause(this.oper.val);
            if (this.expr1 instanceof BinaryExpression) {
                c.addSubexpression(((BinaryExpression)this.expr1).toClause());
            } else if (this.expr1 instanceof Node) {
                c.addLiteral(new Literal(this.expr1.val));
            }
            if (this.expr2 instanceof BinaryExpression) {
                c.addSubexpression(((BinaryExpression)this.expr2).toClause());
            } else if (this.expr1 instanceof Node) {
                c.addLiteral(new Literal(this.expr2.val));
            }
            return c;
        }
    }

    class Node {
        int type;
        String val;
        Node next;

        Node(int type, String val) {
            this.type = type;
            this.val = val;
        }

        public String toString() {
            return this.val + ":" + this.type;
        }
    }

    public static class Clause
    implements LogicalExpression {
        String oper;
        Vector exprs;
        boolean allLiterals;

        public Clause(String oper) {
            this.oper = oper;
            this.exprs = new Vector();
            this.allLiterals = true;
        }

        public int getLayerCount() {
            int max = 0;
            Enumeration e = this.getSubexpressions();
            while (e.hasMoreElements()) {
                LogicalExpression subexpr = (LogicalExpression)e.nextElement();
                max = Math.max(max, subexpr.getLayerCount());
            }
            return max + 1;
        }

        public Enumeration getSubexpressions() {
            return this.exprs.elements();
        }

        public Clause addSubexpression(LogicalExpression le) {
            if (le instanceof Literal) {
                return this.addLiteral((Literal)le);
            }
            return this.addSubexpression((Clause)le);
        }

        public Clause distribute(LogicalExpression le, String op) {
            Expression.debug("Distributing " + le + " under " + op + " into " + this);
            if (this.oper.equals(op)) {
                if (le instanceof Literal) {
                    this.addLiteral((Literal)le);
                } else if (le instanceof Clause) {
                    this.addSubexpression((Clause)le);
                }
                return this;
            }
            Clause c = new Clause(this.oper);
            Enumeration e = this.getSubexpressions();
            while (e.hasMoreElements()) {
                LogicalExpression subexpr = (LogicalExpression)e.nextElement();
                c.addSubexpression(subexpr.distribute(le, op));
            }
            Expression.debug("Distributing returning " + c);
            return c;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String tab) {
            StringBuffer sb = new StringBuffer(tab + "(" + this.oper + "\n");
            Enumeration e = this.getSubexpressions();
            while (e.hasMoreElements()) {
                sb.append(((LogicalExpression)e.nextElement()).toString(tab + "    "));
                if (!e.hasMoreElements()) continue;
                sb.append("\n");
            }
            sb.append(")");
            return sb.toString();
        }

        Clause addLiteral(Literal l) {
            this.exprs.addElement(l);
            return this;
        }

        Clause addSubexpression(Clause c) {
            if (this.oper.equals(c.oper)) {
                Enumeration e = c.getSubexpressions();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof Literal) {
                        this.addLiteral((Literal)o);
                        continue;
                    }
                    if (!(o instanceof Clause)) continue;
                    this.addSubexpression((Clause)o);
                }
            } else {
                this.allLiterals = false;
                this.exprs.addElement(c);
            }
            return this;
        }

        Clause distribute(String op) {
            Expression.debug("Distributing " + this + " under " + op);
            if (this.allLiterals) {
                Expression.debug("" + this + " is all literals.");
                return this;
            }
            Clause newClause = new Clause(this.oper);
            Expression.debug("Still here for for " + this);
            Enumeration e = this.getSubexpressions();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Clause) {
                    newClause.addSubexpression(((Clause)o).distribute(op));
                    continue;
                }
                newClause.addLiteral((Literal)o);
            }
            Expression.debug("After unrolling: " + newClause);
            if (!this.oper.equals(op)) {
                e = newClause.getSubexpressions();
                LogicalExpression s1 = (LogicalExpression)e.nextElement();
                LogicalExpression s2 = null;
                newClause = new Clause(this.oper);
                if (s1 instanceof Literal) {
                    while (e.hasMoreElements()) {
                        s2 = (LogicalExpression)e.nextElement();
                        if (!(s2 instanceof Literal)) break;
                        newClause.addLiteral((Literal)s2);
                    }
                    if (s2 instanceof Literal) {
                        s2 = null;
                    }
                } else {
                    s2 = (LogicalExpression)e.nextElement();
                }
                Expression.debug("s1 = " + s1 + ", s2 = " + s2);
                newClause.addSubexpression(s1.distribute(s2, this.oper));
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof Literal) {
                        newClause.addLiteral((Literal)o);
                        continue;
                    }
                    newClause.addSubexpression((Clause)o);
                }
                if (newClause.exprs.size() == 1) {
                    return (Clause)newClause.exprs.elementAt(0);
                }
                newClause = newClause.distribute(op);
            }
            Expression.debug("Distributed " + this + " into " + newClause);
            return newClause;
        }
    }

    public static class Literal
    implements LogicalExpression {
        Object name;

        public Literal(Object name) {
            this.name = name;
        }

        public Object getName() {
            return this.name;
        }

        public int getLayerCount() {
            return 0;
        }

        public Clause distribute(LogicalExpression le, String op) {
            Expression.debug("Distribute " + le + " into " + this + " under " + op);
            if (le instanceof Literal) {
                Clause clause = new Clause(op);
                clause.addLiteral(this);
                clause.addLiteral((Literal)le);
                return clause;
            }
            return le.distribute(this, op);
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String tab) {
            return tab + this.name.toString();
        }
    }
}

